package com.youra.qlicker.Fragments.RendezVous;

import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.youra.qlicker.Classes.Globals;
import com.youra.qlicker.R;


public class RDVAutreDateFragment extends Fragment {


    private  String[] preferance = { "Matin", "Après-midi", "Soir" };
    private Globals globals;

    public RDVAutreDateFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_rdv_autredate, container, false);

        TextView btn_next = (TextView) view.findViewById(R.id.btn_next);
        ImageView img_back =(ImageView)view.findViewById(R.id.img_back);

        AutoCompleteTextView prevereance = (AutoCompleteTextView)view.findViewById(R.id.dropdown_activete);
        AutoCompleteTextView date = (AutoCompleteTextView)view.findViewById(R.id.dropdown_date);

        //datepicker
        MaterialDatePicker.Builder builder = MaterialDatePicker.Builder.datePicker();
        MaterialDatePicker picker = builder.build();


        //initialise class global
        globals = Globals.getInstance();

        //is checked date
        date.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                picker.show(getActivity().getSupportFragmentManager(), "DATE_PICKER");
            }
        });

        ///select date
        picker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener() {
            @Override
            public void onPositiveButtonClick(Object selection) {

                date.setText( picker.getHeaderText() );

                //set date in class globale
                globals.setDate( picker.getHeaderText() );

            }
        });

        //selected item from preferenace
        prevereance.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                //set preferance in globals variable
                globals.setDate_preferance( preferance[position] );

            }
        });
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(getContext(), android.R.layout.simple_dropdown_item_1line, preferance);
        prevereance.setAdapter(adapter);



        //back to previous fragment
        img_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });

        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {


                    ///set fragment
                    FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                    ft.replace(R.id.frame, new RDV1Fragment()  );

                    ft.commit();


            }
        });

        return view;
    }
}