package com.youra.qlicker.Fragments.RendezVous;

import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridLayout;
import android.widget.TextView;

import com.youra.qlicker.Classes.Globals;
import com.youra.qlicker.R;

import java.text.SimpleDateFormat;
import java.util.Date;


public class RDV1Fragment extends Fragment {



    private Globals globals;
    private GridLayout gridLayout;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_rdv1, container, false);

        TextView btn_next = (TextView) view.findViewById(R.id.btn_next);
        TextView btn_chosedate = (TextView) view.findViewById(R.id.btn_chosedate);

          gridLayout = (GridLayout)view.findViewById(R.id.grid) ;

        //initialise class global
        globals = Globals.getInstance();
        //Initializing the date formatter
        SimpleDateFormat sdf = new SimpleDateFormat("MM dd,yyyy");  //Dec 23,2021
        String currentDate = sdf.format(new Date());

        //set default date (Today)
        if (globals.getDate() ==null) {
            globals.setDate(currentDate);
        }

        /// fill gridlayout
        fillGridlayout();

        //click item from gridlayout
        selectItem();

        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //si une creneux selectione
                if (globals.getTimeSelected() != null) {
                    ///set fragment
                    FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                    Fragment fragment = getActivity().getSupportFragmentManager().findFragmentByTag("rdv2_fragmnet");

                    if (fragment != null) {
                        ft.replace(R.id.frame, fragment);
                    } else {
                        ft.replace(R.id.frame, new RDV2Fragment(), "rdv2_fragmnet");
                    }

                    ft.addToBackStack(null);
                    ft.commit();
                }
            }
        });

        btn_chosedate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                ///set fragment
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();

                ft.replace(R.id.frame, new RDVAutreDateFragment() , "rdv3_fragmnet" );

                ft.addToBackStack(null);
                ft.commit();

            }
        });

        return view;
    }

    private void fillGridlayout(){
        for (int i = 0; i < 3; i++) {
            TextView t =(TextView) LayoutInflater.from(getContext()).inflate(R.layout.item_date  , null );
            t.setText( "11:0"+i);
            gridLayout.addView(t );

        }
    }
    private void selectItem(){
        int childCount = gridLayout.getChildCount();
        for (int i= 0; i < childCount; i++){
            //select time
            TextView item = (TextView) gridLayout.getChildAt(i);
            item.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view){

                    //Deselect all time
                    for (int x= 0; x < childCount; x++){
                        TextView itemS = (TextView) gridLayout.getChildAt(x);

                        itemS.setTextColor(getResources().getColor(R.color.black));
                        itemS.setBackground(getResources().getDrawable( R.drawable.border_date));

                    }

                    //Time select
                    item.setTextColor(getResources().getColor(R.color.white));
                    item.setBackground(getResources().getDrawable( R.drawable.border_date_selected));

                    globals.setTimeSelected(item.getText().toString() );


                    ///Some code .....

                }
            });
        }
    }

}












