package com.youra.qlicker.Classes;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import android.widget.LinearLayout;

public class Globals {


    private static Globals instance;
    private String timeSelected;
    private String date;
    private String date_preferance;

    public Globals( ) {  }

    /**
     * class global contient des variable
     * @return
     */
    public static synchronized Globals getInstance(){
        if (instance == null){

            instance =new Globals();
        }
        return instance;

    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate_preferance() {
        return date_preferance;
    }

    public void setDate_preferance(String date_preferance) {
        this.date_preferance = date_preferance;
    }

    public String getTimeSelected() {
        return timeSelected;
    }

    public void setTimeSelected(String timeSelected) {
        this.timeSelected = timeSelected;
    }

    /**
     * function get scroll position of a WebView
     * @param ly
     * @param view
     * @param scrollY
     */
    public static void isScrolling(Context context ,LinearLayout ly , View view , int scrollY  ){

        WebView webView = (WebView) view;

        float contentHeight = webView.getContentHeight() * webView.getScaleY();
        float total = contentHeight * context.getResources().getDisplayMetrics().density - webView.getHeight();
        // on some devices just 1dp was missing to the bottom when scroll stopped, so we subtract it to reach 1
        float percent = Math.min(scrollY / (total - context.getResources().getDisplayMetrics().density), 1);

        if (scrollY >= total - 1) {

            ly.setVisibility(View.VISIBLE);
            // view.setScaleY( percent );

        }else if (percent < 0.8f ){
            ly.setVisibility(View.GONE);

        }

    }
}
