package com.youra.qlicker.Adapters;
import com.youra.qlicker.Classes.Cart;
import com.youra.qlicker.R;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

import com.makeramen.roundedimageview.RoundedImageView;

import java.util.List;
public class SliderCartAdapter extends RecyclerView.Adapter<SliderCartAdapter.SliderViewHolderc> {
    private List<Cart> sliderItems;



   public SliderCartAdapter(List<Cart> sliderItems ) {
        this.sliderItems = sliderItems;

    }
    @NonNull
    @Override
    public SliderViewHolderc onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SliderViewHolderc(
                LayoutInflater.from(parent.getContext()).inflate(
                        R.layout.item_slider_cart, parent, false
                ));
    }


    @Override
    public void onBindViewHolder(@NonNull SliderViewHolderc holder, int position) {
        holder.setImage(sliderItems.get(position));
//        if (position == sliderItems.size()- 2){
//            viewPager2.post(runnable);
//        }
    }
    @Override
    public int getItemCount() {
        return sliderItems.size();
    }
    static class SliderViewHolderc extends RecyclerView.ViewHolder {
        private ImageView imageView;
        SliderViewHolderc(@NonNull View itemView) {
            super(itemView);
            imageView = itemView.findViewById(R.id.imageView1);
        }

        void setImage(Cart sliderItems){
//use glide or picasso in case you get image from internet
            imageView.setImageResource(sliderItems.getImage());
        }
    }
}
