package com.youra.qlicker.Adapters;

import com.youra.qlicker.Acitvitys.Espace.EspaceActivity;
import com.youra.qlicker.R;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.core.app.ComponentActivity;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

public class EspaceAdapter extends RecyclerView.Adapter<EspaceAdapter.MyViewHolder> {

    private List<String> items;
    private Activity activity;

    public EspaceAdapter(List<String> items , Activity activity){

        this.items = items ;
        this.activity = activity ;
    }


    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        return new MyViewHolder(LayoutInflater.from(parent.getContext()).inflate(
                R.layout.item_espace,
                parent,
                false)
        );




    }

    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.setItem( items.get(position) );

        if (position >1 ){
            holder.ly_parent.setBackgroundColor(activity.getResources().getColor(R.color.grey));
        }

    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {

        private TextView titele ;
        private ImageView img;
        private RelativeLayout ly_parent;


        public MyViewHolder(@NonNull View itemView) {
            super(itemView);
            titele  = itemView.findViewById(R.id.txtv_title);
            img  = itemView.findViewById(R.id.img_add);
            ly_parent  = itemView.findViewById(R.id.ly_parent);

        }

        void setItem(String item){

            titele.setText( item );
            if (item.equals("Ajouter")){
                img.setVisibility(View.VISIBLE);
            }

        }
    }

}