package com.youra.qlicker.Acitvitys.EspacePerso;
import com.hbb20.CountryCodePicker;
import com.youra.qlicker.R;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

public class EPgetPhoneActivity  extends AppCompatActivity {

    private List<Operateur> listoperateur = new ArrayList<Operateur>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_epget_phone);

        TextView btn_next = (TextView) findViewById(R.id.btn_next);
        ImageView img_back = (ImageView) findViewById(R.id.img_back);
        AutoCompleteTextView spiner = (AutoCompleteTextView)findViewById(R.id.dropdown_oprerator);
        CountryCodePicker codePicker = (CountryCodePicker)findViewById(R.id.ccp) ;

        //fill list operateur
        SetOperateur();
        CustemoAdapter adapter =new CustemoAdapter(EPgetPhoneActivity.this ,R.layout.support_simple_spinner_dropdown_item , listoperateur  ) ;
        spiner.setAdapter(adapter);
        spiner.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                try {
                    spiner.setText(  listoperateur.get(position).getName(), false );
                }
                catch (Exception e){
                    e.printStackTrace();
                }

            }
        });
        img_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();

            }
        });

        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                startActivity(new Intent(EPgetPhoneActivity.this, EPcheckPhoneActivity.class ));

            }
        });
    }

    private void SetOperateur(){
        listoperateur.add(new Operateur( "IAM" ,R.drawable.img_boarding1 ));
        listoperateur.add(new Operateur( "INWI" ,R.drawable.img_boarding1 ));
        listoperateur.add(new Operateur( "ORANGE" ,R.drawable.img_boarding1 ));

    }



    private class Operateur{
        private String name ;
        private int img ;

        Operateur(String name,int img){
            this.img = img;
            this.name = name ;

        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getImg() {
            return img;
        }

        public void setImg(int img) {
            this.img = img;
        }
    }

    class CustemoAdapter extends ArrayAdapter<Operateur> {


        public CustemoAdapter(@NonNull Context context ,int resource  , @NonNull List<Operateur> operateurList ) {
            super(context, resource , operateurList);
        }

        @Override
        public int getCount(){
            return listoperateur.size();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(
                        R.layout.item_operateur, parent, false
                );
            }

            TextView nameView = (TextView) convertView.findViewById(R.id.title);
            ImageView img = (ImageView) convertView.findViewById(R.id.imageView);

            Operateur  Item = getItem(position);

            if (Item != null) {

                nameView.setText( listoperateur.get(position).getName());
                img.setImageResource(listoperateur.get(position).getImg()) ;
            }

            return convertView;
        }
    }
}