package com.youra.qlicker.Acitvitys.EER.ProduitP;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;

import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.youra.qlicker.Adapters.SliderCartAdapter;
import com.youra.qlicker.Classes.Cart;
import com.youra.qlicker.R;

import java.util.ArrayList;
import java.util.List;

public class ProdChoseProduitActivity extends AppCompatActivity {


    private ViewPager2 slider;
    private TextView titel1, titel2, decription, btn_addTocard, btn_selected, txt_produis;
    private List<Cart> sliderItems = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_prod_chose_produit);


        TextView btn_next = (TextView) findViewById(R.id.btn_next);
        txt_produis = (TextView) findViewById(R.id.txt_produis);

        TextView btn_info = (TextView) findViewById(R.id.btn_info);
        btn_addTocard = (TextView) findViewById(R.id.btn_add_tocard);
        btn_selected = (TextView) findViewById(R.id.btn_selected);

        titel1 = (TextView) findViewById(R.id.txt_title1);
        titel2 = (TextView) findViewById(R.id.txt_title2);
        decription = (TextView) findViewById(R.id.txt_description);

        slider = (ViewPager2) findViewById(R.id.view_pager);

        fillSlider();
        countCarts();

        btn_info.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                DialogDetail();

            }
        });

        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                  startActivity( new Intent( getApplicationContext() , ProdPostChoseActivity.class ) );

            }
        });

    }

    /**
     * fonction display dialgo info
     */
    private void DialogDetail() {
        Dialog dialog = new Dialog(this);
        dialog.setContentView(R.layout.dialog_detail_produi); // layout
        //dialog.getWindow().setBackgroundDrawableResource(R.drawable.dialog_backg_margin);  // margin draweble
        dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        dialog.setCancelable(true);

        TextView btn_add_to_card = (TextView) dialog.findViewById(R.id.btn_next);
        TextView txt_tite1 = (TextView) dialog.findViewById(R.id.txt_d_title1);
        TextView txt_tite2 = (TextView) dialog.findViewById(R.id.txt_d_title2);
        TextView txt_desc = (TextView) dialog.findViewById(R.id.txt_d_descrpt);
        ImageView img_close = (ImageView) dialog.findViewById(R.id.img_close);
        ImageView img_cart = (ImageView) dialog.findViewById(R.id.img_d);

        Cart cart = sliderItems.get( getCurrenItem(0) );

        txt_tite1.setText( cart.getName_cart());
        txt_tite2.setText( cart.getType_cart());
        txt_desc.setText( cart.getDescription());

        img_cart.setImageResource(cart.getImage());

        img_close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.cancel();
            }
        });
        btn_add_to_card.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                ///add to cart
                btn_addTocard.performLongClick();
                dialog.cancel();
            }
        });

        dialog.show();

    }

    private void fillSlider() {

        sliderItems.add(new Cart(R.drawable.img_carte1, "PACK ENERGY 35", "CARTE VISA", "Retraits et paiements au Maroc et à l’étranger E-paiement sur les sites nationaux et internationaux", false));
        sliderItems.add(new Cart(R.drawable.img_carte2, "PACK ENERGY 22", "Mastre cart", "Retraits et paiements au Maroc  ", false));
        sliderItems.add(new Cart(R.drawable.img_carte3, "PACK ENERGY 24", "CARTE VISA", "Retraits et paiements au Maroc et à l’étranger E-paiement sur les sites nationaux et internationaux", false));
        sliderItems.add(new Cart(R.drawable.img_carte2, "PACK ENERGY 22", "Mastre cart", "Retraits et paiements au Maroc  ", false));

        slider.setAdapter(new SliderCartAdapter(sliderItems));

        slider.setClipToPadding(false);
        slider.setClipChildren(false);
        slider.setOffscreenPageLimit(sliderItems.size());
        slider.getChildAt(0).setOverScrollMode(RecyclerView.OVER_SCROLL_NEVER);

        ///
        slider.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
            @Override
            public void onPageSelected(int position) {
                setItem(position);
            }
        });

        CompositePageTransformer compositePageTransformer = new CompositePageTransformer();
        compositePageTransformer.addTransformer(new MarginPageTransformer(40));
        compositePageTransformer.addTransformer(new ViewPager2.PageTransformer() {
            @Override
            public void transformPage(@NonNull View page, float position) {
                float r = 1 - Math.abs(position);
                page.setScaleY(0.85f + r * 0.15f);

            }
        });

        slider.setPageTransformer(compositePageTransformer);


    }

    /**
     * function count card selected
     */
    private void countCarts() {
        int count = 0;
        for (Cart item : sliderItems) {
            if (item.isSelected()) {
                count++;
            }
        }

        txt_produis.setText(count + " " + getResources().getText(R.string.produit_s));

    }

    private void setItem(int position) {

        titel1.setText(sliderItems.get(position).getName_cart());
        titel2.setText(sliderItems.get(position).getType_cart());
        decription.setText(sliderItems.get(position).getDescription());

        if (!sliderItems.get(position).isSelected()) {
            btn_addTocard.setVisibility(View.VISIBLE);
            btn_selected.setVisibility(View.GONE);
        } else {
            btn_addTocard.setVisibility(View.GONE);
            btn_selected.setVisibility(View.VISIBLE);

        }

    }

    public void clickAdd(View view) {

        btn_addTocard.setVisibility(View.GONE);
        btn_selected.setVisibility(View.VISIBLE);
        sliderItems.get(slider.getCurrentItem()).setSelected(true);
        countCarts();


    }

    public void clickRemove(View view) {

        btn_addTocard.setVisibility(View.VISIBLE);
        btn_selected.setVisibility(View.GONE);
        sliderItems.get(slider.getCurrentItem()).setSelected(false);
        countCarts();

    }

    public void clickNext(View view) {
        if (getCurrenItem(1) < sliderItems.size()) {

            slider.setCurrentItem(getCurrenItem(1));
        }
    }

    private int getCurrenItem(int item) {

        return slider.getCurrentItem() + item;
    }

    public void clickBack(View view) {

        if (getCurrenItem(-1) >= 0) {
            slider.setCurrentItem(getCurrenItem(-1));

        }
    }
}


