package com.youra.qlicker.Acitvitys.EER.KYC;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.youra.qlicker.R;

public class KYCSiteProfActivity extends AppCompatActivity {

    private View thumbView;
    private  String[] Activetes = { "xxxxx", "wwwww", "sssssss" };
    private AutoCompleteTextView drop_activite, drop_prof, drop_revenu, drop_contra, drop_date;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_kycsite_prof);

        ImageView btn_back = (ImageView) findViewById(R.id.img_back);
        TextView btn_next = (TextView) findViewById(R.id.btn_next);

        ///dropdown
          drop_activite=  (AutoCompleteTextView) findViewById(R.id.dropdown_activete);
          drop_prof=  (AutoCompleteTextView) findViewById(R.id.dropdown_prof);
          drop_revenu=  (AutoCompleteTextView) findViewById(R.id.dropdown_revenu);
          drop_contra=  (AutoCompleteTextView) findViewById(R.id.dropdown_typecontra);
          drop_date=  (AutoCompleteTextView) findViewById(R.id.dropdown_calendrie);

        ///range
        TextView txt_selected = (TextView) findViewById(R.id.txt_selected);
        SeekBar range = (SeekBar) findViewById(R.id.seekBar_revune);



        ///fill all dropdown
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_dropdown_item_1line, Activetes);
        drop_activite.setAdapter(adapter);
        drop_prof.setAdapter(adapter);
        drop_revenu.setAdapter(adapter);
        drop_contra.setAdapter(adapter);

        ///inisialis date picker
        MaterialDatePicker.Builder builder = MaterialDatePicker.Builder.datePicker();
        MaterialDatePicker picker = builder.build();

        //click dropdown date
        drop_date.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ///show datepicker
                picker.show(KYCSiteProfActivity.this.getSupportFragmentManager(), "DATE_PICKER");
            }
        });
        ///select date
        picker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener() {
            @Override
            public void onPositiveButtonClick(Object selection) {

                drop_date.setText( picker.getHeaderText() );

            }
        });


        /// change from range bar
        range.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {

                // You can have your own calculation for progress
                seekBar.setThumb(getThumb(progress));
                txt_selected.setText(String.valueOf(progress));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        /// inisialize range
        thumbView = LayoutInflater.from(KYCSiteProfActivity.this).inflate(R.layout.layout_seekbar_thumb, null, false);
        range.setThumb( getThumb(  3000 )  );
        range.setProgress(3000);
        txt_selected.setText("3000");


        /// click btn for return previous activity
        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                 startActivity(new Intent(KYCSiteProfActivity.this,  KYCAgenceActivity.class ));

            }
        });

        /// click btn for return previous activity
        btn_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();
            }
        });
    }

    /**
     * function creet text down from thumb
     * @param progress
     * @return
     */
    private Drawable getThumb(int progress) {
        ((TextView) thumbView.findViewById(R.id.tvProgress)).setText(progress + "");

        thumbView.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
        Bitmap bitmap = Bitmap.createBitmap(thumbView.getMeasuredWidth(), thumbView.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        thumbView.layout(0, 0, thumbView.getMeasuredWidth(), thumbView.getMeasuredHeight());
        thumbView.draw(canvas);

        return new BitmapDrawable(getResources(), bitmap);
    }


}