package com.youra.qlicker.Acitvitys.EER.KYC;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

import com.youra.qlicker.R;

public class KYCSitFamTowActivity extends AppCompatActivity {

    private View thumbView;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_kycsit_fam_tow);

        ImageView btn_back = (ImageView) findViewById(R.id.img_back);
        TextView btn_next = (TextView) findViewById(R.id.btn_next);

        ///range
        TextView txt_selected = (TextView) findViewById(R.id.txt_selected);
        SeekBar range = (SeekBar) findViewById(R.id.seekBar_enfant);

        /// change from range bar
        range.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {

                // You can have your own calculation for progress                    
                seekBar.setThumb(getThumb(progress));
                txt_selected.setText(String.valueOf(progress));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        /// inisialize range
          thumbView = LayoutInflater.from(KYCSitFamTowActivity.this).inflate(R.layout.layout_seekbar_thumb, null, false);
        range.setThumb( getThumb(  0 )  );
        range.setProgress(0);
        txt_selected.setText("0");



        /// click btn continuer
        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                startActivity(new Intent(KYCSitFamTowActivity.this , KYCSiteProfActivity.class ));
            }
        });
        /// click btn for return previous activity
        btn_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();
            }
        });
    }

    public Drawable getThumb(int progress) {
        ((TextView) thumbView.findViewById(R.id.tvProgress)).setText(progress + "");

        thumbView.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
        Bitmap bitmap = Bitmap.createBitmap(thumbView.getMeasuredWidth(), thumbView.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        thumbView.layout(0, 0, thumbView.getMeasuredWidth(), thumbView.getMeasuredHeight());
        thumbView.draw(canvas);

        return new BitmapDrawable(getResources(), bitmap);
    }
}