package com.youra.qlicker.Acitvitys.EER.KYC;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.GridLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.hbb20.CountryCodePicker;
import com.youra.qlicker.R;

public class KYCAEOIActivity extends AppCompatActivity {

    private GridLayout gridLayout;
    private TextView btn_next;
    private CheckBox check_py, check_pys;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_kyc_aeoi);

        AutoCompleteTextView dropcountry = (AutoCompleteTextView) findViewById(R.id.dropdown_country);
        CountryCodePicker country = (CountryCodePicker) findViewById(R.id.ccp);

        ImageView btn_back = (ImageView) findViewById(R.id.img_back);
        btn_next = (TextView) findViewById(R.id.btn_next);
        TextView btn_add = (TextView) findViewById(R.id.btn_add);
        check_py = (CheckBox) findViewById(R.id.checkbox_pays);
        check_pys = (CheckBox) findViewById(R.id.checkbox_puissance);
        gridLayout = (GridLayout) findViewById(R.id.grid);



        /// click btn for return previous activity
        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                  startActivity(new Intent(KYCAEOIActivity.this,   KYCWNineActivity.class ));

            }
        });

        /// click btn for return previous activity
        btn_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();
            }
        });

        // ajouter autre pays
        btn_add.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //add item from grid layout
                addItem();
            }
        });

        //add first item
        addItem();

        //is checked
        check_py.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                if (isChecked) {
                    btn_next.getBackground().setTint(getResources().getColor(R.color.primary));
                    btn_next.setEnabled(true);
                } else {
                    btn_next.getBackground().setTint(getResources().getColor(R.color.disabled));
                    btn_next.setEnabled(false);
                }

            }
        });


        ///check  contry
        dropcountry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                country.launchCountrySelectionDialog();

            }
        });
        country.setOnCountryChangeListener(new CountryCodePicker.OnCountryChangeListener() {
            @Override
            public void onCountrySelected() {
                dropcountry.setText( country.getSelectedCountryName()  );

            }
        });

    }

    /**
     * add item from gridlayout
     */
    private void addItem() {
        View view = (View) LayoutInflater.from(this).inflate(R.layout.item_kyc_aeoi, null);
        gridLayout.addView(view);

    }

    /**
     * encour
     */
    private void selectItem() {
        int childCount = gridLayout.getChildCount();
        for (int i = 0; i < childCount; i++) {
            //select time
            View item = (View) gridLayout.getChildAt(i);

        }
    }


}