package com.youra.qlicker.Acitvitys.CGU;

import com.youra.qlicker.Adapters.SliderAdapter;
import com.youra.qlicker.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager.widget.ViewPager;

import android.content.Intent;
import android.os.Bundle;
import android.text.Html;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;


public class OnboardingActivity extends AppCompatActivity {


    ViewPager mSLideViewPager;
    LinearLayout mDotLayout;
    TextView nextbtn , btn_finish;

    TextView[] dots = new TextView[4];
    SliderAdapter viewPagerAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_onboarding);


        nextbtn =(TextView) findViewById(R.id.btn_next);
        btn_finish =(TextView) findViewById(R.id.btn_finish);

        //next tape
        nextbtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (getitem(0) < 3){
                    mSLideViewPager.setCurrentItem(getitem(1),true);

                }

                if (getitem(0) < 3){

                    mDotLayout.setVisibility(View.VISIBLE);
                    btn_finish.setVisibility(View.GONE);
                    nextbtn.setVisibility(View.VISIBLE);

                }
                else {
                    mDotLayout.setVisibility(View.GONE);
                    btn_finish.setVisibility(View.VISIBLE);
                    nextbtn.setVisibility(View.GONE);
                }

            }
        });

        /// start new activity
        btn_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent intent = new Intent(OnboardingActivity.this , CGU1Activity.class);
                startActivity( intent );

            }
        });

        mSLideViewPager = (ViewPager) findViewById(R.id.view_pager);
        mDotLayout = (LinearLayout) findViewById(R.id.ly_dots);

        viewPagerAdapter = new SliderAdapter(this);

        mSLideViewPager.setAdapter(viewPagerAdapter);

        setUpindicator(0);
        mSLideViewPager.addOnPageChangeListener(viewListener);

    }

    public void setUpindicator(int position){

        dots = new TextView[4];
        mDotLayout.removeAllViews();

        for (int i = 0 ; i < dots.length ; i++){

            dots[i] = new TextView(this);
            dots[i].setText(Html.fromHtml("&#8226"));
            dots[i].setTextSize(45);
            dots[i].setTextColor(getResources().getColor(R.color.inactive));
            mDotLayout.addView(dots[i]);

        }

        dots[position].setTextColor(getResources().getColor(R.color.primary ));

    }

    ViewPager.OnPageChangeListener viewListener = new ViewPager.OnPageChangeListener() {
        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

        }

        @Override
        public void onPageSelected(int position) {


            if (getitem(0) < 3){

                mDotLayout.setVisibility(View.VISIBLE);
                btn_finish.setVisibility(View.GONE);
                nextbtn.setVisibility(View.VISIBLE);

            }
            else {
                mDotLayout.setVisibility(View.GONE);
                btn_finish.setVisibility(View.VISIBLE);
                nextbtn.setVisibility(View.GONE);
            }

            setUpindicator(position);


        }

        @Override
        public void onPageScrollStateChanged(int state) {

        }
    };

    private int getitem(int i){

        return mSLideViewPager.getCurrentItem() + i;
    }
}