## Installation
### `1. Install dependencies :`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

* ~ For `Windows` run :
                            
npm i skyid-sdk-web-win

                        
* ~ For `Linux/Mac` run : 
                            
npm i skyid-sdk-web-lx

### `2.In your components import the Jquery and the SDK Web :`
       
'                           
<script>
import $ from 'jquery';
import * as skyid_imp from '../assets/skyid_impl_v1'; //Location of 'skyid_impl_v1.js' file
...
</script>'

                        
### `3.copy the code bellow inside the useEffect(){...} lifecycle Hook:`
                            
  useEffect(()=>{
        skyid_imp.initViewComponent()
        // init SDK
        skyid_imp.skyid_fa_remote_sdk_initialization()
    
    $( document ).ready(function() {
        $("#skyid_fa_document_container").show(500);
    
        $( "#skyid_da_smart_ocr_button" ).click(function() {
                skyid_imp.skyid_fa_auth_request_smart_ocr();
                $("#skyid_da_smart_ocr_button").prop('disabled', true);
                $("#skyid_da_smart_ocr_button").html("extraction d'information en cours ...");
        });
    
        $( "#skyid_fa_next" ).click(function() {
            $( "#skyid_fa_start_button" ).show()
          skyid_imp.show_matching_step();
        });
    
        $( "#skyid_fa_start_button" ).click(function() {
                  // start SDK face analysis
                  skyid_imp.start_face_scan() ;
                       $( "#skyid_fa_start_button" ).hide();
                       $( "#msg" ).html("Scanne de visage en cours ....");
         });
    
    });
    
    const fileSelector = document.getElementById('file-upload');
      fileSelector.addEventListener('change', (event) => {
        const myimage = event.target.files[0];
        skyid_imp.readImage(myimage);
      });
    
    // demo call
    skyid_imp.skyid_fa_auth_request_smart_ocr_recover("1671122267893033679")
    },[])

                        
### `4.Copy the HTML code :`
                            
<div class="wrapper">
  <div id="skyid_fa_document_container">
          
    <div id="skyid_document_browser">
        <label For="file-upload" class="custom-file-upload" id="doc_file_label">
             Charger votre document ici
        </label>
        <input id="file-upload" type="file" value="" accept="image/png, image/jpeg"/>
        <button   id="skyid_da_smart_ocr_button" class="button-36" role="button">Extraire les information de document</button>
        <button   id="skyid_fa_next" class="button-36" role="button">Suivant</button>
        <br/><br/>
        <img id="doc_img" src='../assets/no-img-placeholder.png' width="640px" height="480px" alt=""/>
        <p id="extracted_feilds"></p>
    </div>
    <div id="liveness_frame">
        <div id="skyid_liveness" ></div>
        <br/><br/>
        <button   id="skyid_fa_start_button" class="button-36" role="button">Démarrer</button>
        <br/>
        <div id="msg"></div>
        
    </div>
  </div>
  

                        
### `5.Add CSS style:`
                            
<style>
     html, body {
    height: 100%;
    width: 100%;
    margin: 0;
    background-color: #f5f5f5;
    display: table;
}

footer {
    background-color: black;
    font-size:12px;
    display: table-row;
    padding: 20px;
    height: 0;
    font-family: Arial, Helvetica, sans-serif;
}

.column {
  float: left;
  padding: 20px;
}

/* Clear floats after the columns */
.row:after {
  content: "";
  display: table;
  clear: both;
}

.button-36 {
background-image: linear-gradient(92.88deg, #455EB5 9.16%, #5643CC 43.89%, #673FD7 64.72%);
border-radius: 8px;
border-style: none;
box-sizing: border-box;
color: #FFFFFF;
cursor: pointer;
flex-shrink: 0;
font-family: "Inter UI","SF Pro Display",-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Open Sans","Helvetica Neue",sans-serif;
font-size: 16px;
font-weight: 500;
height: 4rem;
padding: 0 1.6rem;
text-align: center;
text-shadow: rgba(0, 0, 0, 0.25) 0 3px 8px;
transition: all .5s;
user-select: none;
-webkit-user-select: none;
touch-action: manipulation;
}

.button-36:hover {
box-shadow: rgba(80, 63, 205, 0.5) 0 1px 30px;
transition-duration: .1s;
}

@media (min-width: 768px) {
.button-36 {
  padding: 0 2.6rem;
}
}

input[type="file"] {
display: none;
}

.custom-file-upload {
border: 1px solid #ccc;
background-image: linear-gradient(92.88deg, #455EB5 9.16%, #5643CC 43.89%, #673FD7 64.72%);
border-radius: 8px;
color: #FFFFFF;
flex-shrink: 0;
font-family: "Inter UI","SF Pro Display",-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Open Sans","Helvetica Neue",sans-serif;
display: inline-block;
padding: 6px 12px;
cursor: pointer;
}

.custom-file-upload:hover {
box-shadow: rgba(80, 63, 205, 0.5) 0 1px 30px;
transition-duration: .1s;
}

#skyid_fa_document_container{
  margin: auto;
  width: 90%;
  text-align: center;
}
#skyid_da_smart_ocr_button, #skyid_fa_next,#skyid_fa_document_container,#skyid_fa_start_button{
  display: none;
}
#extracted_feilds{
  display:none;
  border: 2px solid #000;
  overflow: scroll;
}
#liveness_frame{
  display: none;
  text-align: center;
}
#skyid_liveness{
  display: flex;
  justify-content: center;
}

</style>



# Getting Started with Create React App

This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app).

## Available Scripts

In the project directory, you can run:

### `npm start`

Runs the app in the development mode.\
Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

### `npm test`

Launches the test runner in the interactive watch mode.\
See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.

### `npm run build`

Builds the app for production to the `build` folder.\
It correctly bundles React in production mode and optimizes the build for the best performance.

The build is minified and the filenames include the hashes.\
Your app is ready to be deployed!

See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.

### `npm run eject`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

If you aren't satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.

Instead, it will copy all the configuration files and the transitive dependencies (webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you're on your own.

You don't have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn't feel obligated to use this feature. However we understand that this tool wouldn't be useful if you couldn't customize it when you are ready for it.

## Learn More

You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).

To learn React, check out the [React documentation](https://reactjs.org/).

### Code Splitting

This section has moved here: [https://facebook.github.io/create-react-app/docs/code-splitting](https://facebook.github.io/create-react-app/docs/code-splitting)

### Analyzing the Bundle Size

This section has moved here: [https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size](https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size)

### Making a Progressive Web App

This section has moved here: [https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app](https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app)

### Advanced Configuration

This section has moved here: [https://facebook.github.io/create-react-app/docs/advanced-configuration](https://facebook.github.io/create-react-app/docs/advanced-configuration)

### Deployment

This section has moved here: [https://facebook.github.io/create-react-app/docs/deployment](https://facebook.github.io/create-react-app/docs/deployment)

### `npm run build` fails to minify

This section has moved here: [https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify](https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify)
