"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const src_1 = require("../src");
exports.default = (0, src_1.createBuilder)((options, context) => {
    const allRuns = [];
    context.reportProgress(0, (options.targets ? options.targets.length : 0) +
        (options.builders ? options.builders.length : 0));
    if (options.targets) {
        allRuns.push(...options.targets.map(({ target: targetStr, overrides }, i) => {
            const [project, target, configuration] = targetStr.split(/:/g, 3);
            return context
                .scheduleTarget({ project, target, configuration }, overrides || {})
                .then((run) => [i, run]);
        }));
    }
    if (options.builders) {
        allRuns.push(...options.builders.map(({ builder, options }, i) => {
            return context
                .scheduleBuilder(builder, options || {})
                .then((run) => [i, run]);
        }));
    }
    const allResults = allRuns.map(() => null);
    let n = 0;
    context.reportProgress(n++, allRuns.length);
    return (0, rxjs_1.from)(allRuns).pipe((0, operators_1.mergeMap)((runPromise) => (0, rxjs_1.from)(runPromise)), (0, operators_1.mergeMap)(([i, run]) => run.output.pipe((0, operators_1.map)((output) => [i, output]))), (0, operators_1.mergeMap)(([i, output]) => {
        allResults[i] = output;
        context.reportProgress(n++, allRuns.length);
        if (allResults.some((x) => x === null)) {
            // Some builders aren't done running yet.
            return rxjs_1.EMPTY;
        }
        else {
            return (0, rxjs_1.of)({
                success: allResults.every((x) => (x ? x.success : false)),
            });
        }
    }));
});
//# sourceMappingURL=data:application/json;base64,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