/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { XhrFactory as XhrFactory_fromAngularCommon } from '@angular/common';
/**
 * A wrapper around the `XMLHttpRequest` constructor.
 *
 * @publicApi
 * @see `XhrFactory`
 * @deprecated
 * `XhrFactory` has moved, please import `XhrFactory` from `@angular/common` instead.
 */
export const XhrFactory = XhrFactory_fromAngularCommon;
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpContext, HttpContextToken } from './src/context';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS, HttpInterceptorHandler as ɵHttpInterceptorHandler } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpFeatureKind, provideHttpClient, withJsonpSupport, withNoXsrfProtection, withXsrfConfiguration, withInterceptors, withInterceptorsFromDi, withRequestsMadeViaParent } from './src/provider';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { HttpXhrBackend } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
// This re-export exists because g3 depends on this old private name.
export { HttpInterceptorHandler as ɵHttpInterceptingHandler } from './src/interceptor';
//# sourceMappingURL=data:application/json;base64,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