"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addError = exports.addWarning = exports.createDiagnosticsReporter = void 0;
const typescript_1 = require("typescript");
function createDiagnosticsReporter(compilation, formatter) {
    return (diagnostics) => {
        for (const diagnostic of diagnostics) {
            const text = formatter(diagnostic);
            if (diagnostic.category === typescript_1.DiagnosticCategory.Error) {
                addError(compilation, text);
            }
            else {
                addWarning(compilation, text);
            }
        }
    };
}
exports.createDiagnosticsReporter = createDiagnosticsReporter;
function addWarning(compilation, message) {
    compilation.warnings.push(new compilation.compiler.webpack.WebpackError(message));
}
exports.addWarning = addWarning;
function addError(compilation, message) {
    compilation.errors.push(new compilation.compiler.webpack.WebpackError(message));
}
exports.addError = addError;
//# sourceMappingURL=data:application/json;base64,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