export default {
    // information sent after creation of applicationId by mail
    OCR_url : "***",
    OCR_url_status : "***",
    LIVENESS_url : "***",
    FACE_MATCHING_url : "***",
    skyid_fa_sdk_params_url : "***",
    Recover_Face_Matching_Result_URL : "***",
  
    institution_id : "***",
    skyid_fa_sdk_user : "***",
    skyid_fa_sdk_password : "***",
    skyid_fa_sdk_token : "***",
    skyid_fa_sdk_appId : "***",


    setFileImage(my_selfie_canvas) {
        console.log(my_selfie_canvas)
        const canvas_bin = this.skyid_fa_canvas2binary(my_selfie_canvas);
        return new File([canvas_bin], "skyid_fa_selected_frame.jpg", { type: "application/octet-stream" })
    },
    skyid_fa_canvas2binary(req_canvas) {
        let skyid_fa_canvas_data = req_canvas.toDataURL('image/jpeg', 1.0);
        skyid_fa_canvas_data = skyid_fa_canvas_data.replace('data:image/jpeg;base64,', '');
        return this.skyid_fa_base64ToArrayBuffer(skyid_fa_canvas_data)
    },
    skyid_fa_base64ToArrayBuffer(base64) {
        const binary_string = window.atob(base64);
        const len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0; i < len; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    },
    resizeImage (file) {
        console.log(file);
        const defaultQualityRatio = 0.9;
        const imageType = file.type || 'image/jpeg';
        return new Promise((resolve, reject) => {
          const reader = new FileReader();
      
          reader.readAsDataURL(file);
      
          reader.onload = (e) => {
            const img = new Image();
            img.src = e.target.result;
      
            img.onload = () => {
              const canvas = document.createElement('canvas');
              const ctx = canvas.getContext('2d');
      
              canvas.width = 1000;
              canvas.height = 600;
      
              if (img.width < img.height) {
                canvas.width = 600;
                canvas.height = 1000;
              }
      
              if (img.width > canvas.width || img.height > canvas.height) {
                ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
                ctx.canvas.toBlob(
                  (blob) => {
                    resolve(
                      new File([blob], file.name, {
                        type: imageType,
                        lastModified: Date.now(),
                      })
                    );
                  },
                  imageType,
                  defaultQualityRatio
                );
              }
            };
          };
          reader.onerror = (error) => {reject(error);};
        });
    }
}
