import React, { useState, useEffect } from 'react';
import axios from 'axios';
import helper from '../config/helperConfig';
import * as skyid from 'skyid-sdk-web';


const SkyIdentification = () => {
  const [selectedFile, setSelectedFile] = useState(null);
  const [responseLogin, setResponseLogin] = useState(null);
  const [responseOcr, setResponseOcr] = useState(null);
  const [responseLiveness, setResponseLiveness] = useState(null);
  const [responseFaceMatching, setResponseFaceMatching] = useState(null);
  const [displaybtn, setdisplaybtn] = useState(null);
  const [imageSrc, setImageSrc] = useState("/assets/CINcrt.jpg");

  const handleFileChange = (event) => {
    readImage(event.target.files[0]);
  };

  const readImage = (file) => {
    const reader = new FileReader();
    //setSelectedFile(file);
    resizeImage(file);
    reader.onload = function () {
      setImageSrc(reader.result);
  };
    console.log(file)
    skyid_extract_info_from_doc_request(file, responseLogin.response_data.access_token);
  };

  const login = async () => {
    const formData = new FormData();
    formData.append("username", helper.skyid_fa_sdk_user);
    formData.append("password", helper.skyid_fa_sdk_password);
    axios.post(helper.skyid_fa_sdk_params_url+"login", formData)
      .then(response => {
        setResponseLogin(response.data);
        if (response.data.status_code === "000") {
          get_parameters(response.data.response_data.access_token);
        }
      })
      .catch(error => {
        console.error('Error login', error);
      });
  };

  const get_parameters = async (bearToken) => {
    const formData = new FormData();
    formData.append("token", helper.skyid_fa_sdk_token);
    formData.append("application_id", helper.skyid_fa_sdk_appId);
    axios.post(helper.skyid_fa_sdk_params_url+"get_parameters_web_sdk", formData, {
      headers: {
        Authorization: `Bearer ${bearToken}`,
        'Content-Type': 'multipart/form-data',
      }
    })
      .then(response => {
        console.log('get_params success', response.data);
        if (response.data.status_code === "000") {
          skyid.skyid_fa_init_sdk(response.data.response_data);
        }
      })
      .catch(error => {
        console.error('get_params error', error);
      });
  };

  const skyid_extract_info_from_doc_request = (myImage, bearToken) => {
    const formData = new FormData();
    formData.append("token", helper.skyid_fa_sdk_token);
    formData.append("document", myImage);
    formData.append('institution_id', helper.institution_id);
    formData.append('application_id', helper.skyid_fa_sdk_appId);
    formData.append('channel_id', "02");
    formData.append('service_id', "09");
    formData.append('sub_service_id', "005");
    formData.append("request_data", '{"doc_type":"09"}');
    axios.post(helper.OCR_url, formData, {
      headers: {
        Authorization: `Bearer ${bearToken}`,
        'Content-Type': 'multipart/form-data',
      }
    })
      .then(response => {
        console.log('ocr success', response.data);
        if (response.data.status_code === "000") {
          setResponseOcr(response.data);
          init();
        }
      })
      .catch(error => {
        console.error('ocr error', error);
      });
  };

  const startScanFace = () => {
    skyid.skyid_fa_start_face_scan(skyidFaFaceScanEndCallback, processFaTimeOut);
  };

  const skyidFaFaceScanEndCallback = async (frame) => {
    const face_image = helper.setFileImage(frame);
    const formData = new FormData();
    const bearToken = responseLogin.response_data.access_token;
    formData.append("selfie", face_image);
    axios.post(helper.LIVENESS_url, formData, {
      headers: {
        Authorization: `Bearer ${bearToken}`,
        'Content-Type': 'multipart/form-data',
      }
    })
      .then(response => {
        console.log('ocr success', response.data);
        if (response.data.status_code === "000") {
          setResponseLiveness(response.data);
          skyid.skyid_fa_start_face_scan(skyid_face_scan_end_callbackfacematching, processFaTimeOut);
        }
      })
      .catch(error => {
        console.error('ocr error', error);
      });
  };

  const skyid_face_scan_end_callbackfacematching = async (frame) => {
    const face_image = helper.setFileImage(frame);
    const formData = new FormData();
    const bearToken = responseLogin.response_data.access_token;
    formData.append("doc_1_1", selectedFile);
    formData.append("slf_1", face_image);
    formData.append('guid', "***");
    formData.append("token", helper.skyid_fa_sdk_token);
    formData.append("application_id", helper.skyid_fa_sdk_appId);
    axios.post(helper.FACE_MATCHING_url, formData, {
      headers: {
        Authorization: `Bearer ${bearToken}`,
        'Content-Type': 'multipart/form-data',
      }
    })
      .then(response => {
        console.log('ocr success', response.data);
        if (response.data.status_code === "000") {
          setResponseFaceMatching(response.data);
        }
      })
      .catch(error => {
        console.error('ocr error', error);
      });

  };

  const processFaTimeOut = () => {
    console.log("processFaTimeOut");
  };

  const init = () => {
    setdisplaybtn(true);
    let skyid_liveness = document.getElementById('skyid_liveness');
    skyid_liveness.innerHTML = skyid.skyid_component;
    skyid.skyid_fa_setup_sdk();
  };

  // rezise image function
  const resizeImage = (file) => {

    const reader = new FileReader();
    reader.onload = (e) => {
      const img = new Image();
      img.src = e.target.result;
      img.onload = () => {
        const canvas = document.createElement('canvas');
        const ctx = canvas.getContext('2d');
        
        canvas.width = 1000;
        canvas.height = 600;
        if(img.width < img.height){
          console.log("rezised")
          canvas.width = 600;
          canvas.height = 1000;
        }

        if(img.width > canvas.width || img.height > canvas.height){

          console.log("Im here")
          ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
            canvas.toBlob(
              (blob) => {
                if (blob) {
                  const resizedFile = new File([blob], file.name, {
                    type: file.type,
                    lastModified: Date.now(),
                  });
                  console.log('Resized File:', resizedFile);
                  setSelectedFile(resizedFile);
                } else {
                  console.error('Failed to create Blob.');
                }
              },
              file.type, // Set the image type explicitly
              0.9 // Adjust the quality (0.0 to 1.0, 1.0 for maximum quality)
            );
        }
      };
    };
  
    reader.readAsDataURL(file);
  };


  const setMessage = () => {
    skyid.message_variables.skyid_fa_sdk_access_error_message = "Votre token n'est pas valide";
    skyid.message_variables.skyid_fa_sdk_loading_error_message = "Error lors de chargement des modules";
    skyid.message_variables.skyid_fa_sdk_network_error_message = "Error de connexion au serveur, merci de verifier votre connexion internet";
    skyid.message_variables.skyid_fa_sdk_camera_error_message = "Impossible de demmarer votre camera, merci de verifier que votre camera et bien actif";
    skyid.message_variables.skyid_fa_face_start_message = "SVP positionner votre visage au centre sans rotation. puis clique sur start.";
    skyid.message_variables.skyid_fa_face_loading_message = "Chargement des modules, Patietez SVP.";
    skyid.message_variables.skyid_fa_mul_face_warning_msg = "SVP representer un seul visage devant le camera.";
  }

  useEffect(() => {
    login();
    setMessage();
  }, []);

  return (
    <div className="main_container">
      <br/>
      <div>
        <img src="/assets/IndatacoreIdentity.png" className="IndatacoreIdentity" alt="" />
      </div>

      <h1>It only takes one more click to discover Sky ID on the web channel.</h1>

      <div id="multi-step-form-container">

        <input type="file" onChange={handleFileChange} />
        <img src={`${imageSrc}`} />

        <br/>
        {responseLogin && (
          <div className='code-json'>
          <br/>
            <h2>Server Response Login :</h2>
            <pre>{JSON.stringify(responseLogin, null, 2)}</pre>
          </div>
        )}

        <br />
        {responseOcr && (
          <div className='code-json'>
            <h2>Server Response OCR:</h2>
            <pre>{JSON.stringify(responseOcr, null, 2)}</pre>
          </div>
        )}
        <br/>
        <div id="skyid_liveness"></div>
        <br/>
        {displaybtn && (
          <button  onClick={startScanFace}>Start Scan Face</button>
        )}
        <div className='code-json'>
        <br />
          {responseLiveness && (
            <div>
              <h2>Server Response Liveness:</h2>
              <pre>{JSON.stringify(responseLiveness, null, 2)}</pre>
            </div>
          )}
        </div>
        <br />
        <div>
          {responseFaceMatching && (
            <div className='code-json'>
              <h2>Server Response Face Matching :</h2>
              <pre>{JSON.stringify(responseFaceMatching, null, 2)}</pre>
            </div>
          )}
        </div>

      </div>



    </div>
  );
};

export default SkyIdentification;
