import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { ConfigHelper } from '../Helper/ConfigHelper';

@Injectable({
  providedIn: 'root'
})
export class IdentificationService {

  helperSky = new ConfigHelper();
  constructor(private httpClient: HttpClient) { }

  login(email:string, password:string){
    var form = new FormData();
    form.append("username", email);
    form.append("password", password);
    var headers = new HttpHeaders();
    headers.set('Content-Type', 'multipart/form-data');
    headers.set('Accept', '*/*');
    return this.httpClient.post(this.helperSky.skyid_fa_sdk_params_url+"login", form, {headers: headers});
  }

  skyid_fa_get_params_request(bearToken:string){
    var form = new FormData();
    form.append("token", this.helperSky.skyid_fa_sdk_token);
    form.append("application_id", this.helperSky.skyid_fa_sdk_appId);
    var headers = new HttpHeaders({
      Authorization: `Bearer ${bearToken}`,
    });
    return this.httpClient.post(this.helperSky.skyid_fa_sdk_params_url+"get_parameters_web_sdk", form, {headers:headers});
  }
  
  skyid_fa_check_liveness_request(face_image:any,bearToken : string){
    var form = new FormData();
    form.append("selfie",face_image);
    var headers = new HttpHeaders({
      Authorization: `Bearer ${bearToken}`,
    });
    return this.httpClient.post(this.helperSky.LIVENESS_url, form, {headers:headers});
  }

  skyid_fa_face_scan_end_callbackfacematching(docImage: File, face_image: File, bearToken:string, guid: string){
    var form = new FormData();
    form.append("doc_1_1", docImage);
    form.append("slf_1", face_image);
    form.append('guid', guid);
    form.append("token", this.helperSky.skyid_fa_sdk_token);
    form.append("application_id", this.helperSky.skyid_fa_sdk_appId);
    var headers = new HttpHeaders({
      Authorization: `Bearer ${bearToken}`,
    });
    return this.httpClient.post(this.helperSky.FACE_MATCHING_url, form, {headers:headers});
  }
  
}
