import { Component, OnInit } from '@angular/core';
import { IdentificationService } from './service/identification.service';
//@ts-ignore
import * as skyid from 'skyid-sdk-web';
import { ConfigHelper } from './Helper/ConfigHelper';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent implements OnInit {
  title = "sky_Identification_Angular_Demo";
  imageSrc = "../../assets/CINcrt.jpg";
  fileImage : any;
  // used to get the token after the login
  bearToken!: string;
  document_uniqueName!: string;

  // used to display data
  response_liveness : any;
  response_face: any;


  my_selfie_canvas :any;
  binaryFile: any;

  displayButton! : boolean;

  loadSpinnerDisplay: boolean = false;
  loadDataFaceDisplay: string = 'none';
  loadDataDocDisplay: string = 'block';

    // Config Object
  helperSky = new ConfigHelper();

  constructor(private identificatioService: IdentificationService){
    skyid.message_variables.skyid_fa_sdk_access_error_message = "Votre token n'est pas valide";
    skyid.message_variables.skyid_fa_sdk_loading_error_message = "Error lors de chargement des modules";
    skyid.message_variables.skyid_fa_sdk_network_error_message = "Error de connexion au serveur, merci de verifier votre connexion internet";
    skyid.message_variables.skyid_fa_sdk_camera_error_message = "Impossible de demmarer votre camera, merci de verifier que votre camera et bien actif";
    skyid.message_variables.skyid_fa_face_start_message = "SVP positionner votre visage au centre sans rotation. puis clique sur start.";
    skyid.message_variables.skyid_fa_face_loading_message = "Chargement des modules, Patietez SVP.";
    skyid.message_variables.skyid_fa_mul_face_warning_msg = "SVP representer un seul visage devant le camera.";
  }

  ngOnInit(): void {
    this.login(this.helperSky.skyid_fa_sdk_user, this.helperSky.skyid_fa_sdk_password);
  }

  tryagain(){
    window.location.reload()
  }

  // Login method
  login(email: string, password: string){
    this.identificatioService.login(email, password).subscribe((data:any) =>{
      console.log(data);
      if(data.status_code == "000"){
        this.bearToken = data.response_data.access_token;
        this.skiDetecFace(this.bearToken);
      }else{
        alert('Erreur de connexion');
        this.displayButton = true;
      }
    }, error => {
      alert("Try later");
      this.displayButton = true;
    });
  }


  // Sky get params  method with  step
  skiDetecFace(bearToken: string){
    this.identificatioService.skyid_fa_get_params_request(bearToken).subscribe((data:any) => {
        skyid.skyid_fa_init_sdk(data.response_data);
      }, error => {
        alert("Try later")
      });
  }


  // Next for initializ
  next(){
    this.init();
    this.displayButton = false;
    this.loadDataFaceDisplay = 'block';
    this.loadDataDocDisplay = 'none';
  }

  // get file in our input
  changeImage(event:any){
    var files = event.target.files;
    var file = files[0];
    console.log(file);
    if (files && file) {
        var reader = new FileReader();
        reader.onload = this.handleReaderLoaded.bind(this);
        reader.readAsBinaryString(file);
        this.binaryFile = file;
        this.next();
    } 
  }

  // convert image to base64
  handleReaderLoaded(readerEvt:any) {
    var binaryString = readerEvt.target.result;
    this.imageSrc = 'data:image/png;base64,' + btoa(binaryString);           
  }

  // Camera launcher
  init(){
      let skyid_liveness = document.getElementById('skyid_liveness');
      skyid_liveness!.innerHTML = skyid.skyid_component;
      skyid.skyid_fa_setup_sdk();
  }

  // Method used to start liveliness
  startScanFace(){
    this.loadSpinnerDisplay = true;
    skyid.skyid_fa_start_face_scan(this.skyid_fa_face_scan_end_callback.bind(this), this.process_fa_timeOut);
    this.displayButton = true;
  }

  // Trigger when face analysis does not detect a valid face.
  process_fa_timeOut() {
    console.log("process_fa_timeOut ");
  }

  // Trigger when face analysis is done. It returns the result of face analysis .
  skyid_fa_face_scan_end_callback(skyid_fa_detected_face_canvas: any) {
    this.my_selfie_canvas = skyid_fa_detected_face_canvas
    this.skyid_fa_check_liveness(skyid_fa_detected_face_canvas);
  }

  // Method used to contact the API
  skyid_fa_check_liveness(frame : any){
    const face_image = this.helperSky.setFileImage(frame);
    this.identificatioService.skyid_fa_check_liveness_request(face_image, this.bearToken).subscribe((data: any) => {
      if(data.status_code == "000" && data.response_data.face_class == "Real"){
        this.response_liveness = data;
        skyid.skyid_fa_start_face_scan(this.skyid_fa_face_scan_end_callbackfacematching.bind(this), this.process_fa_timeOut);
      }else{
        skyid.skyid_fa_stop_webcam();
        this.displayButton = true;
        this.loadSpinnerDisplay = false;
      }
    }, error => {
      skyid.skyid_fa_stop_webcam();
      alert("Try later")
      this.displayButton = true;
      this.loadSpinnerDisplay = false;
    });
  }

  // callback protocol to re-implement. Trigger when face analysis is done. It returns the result of face analysis :
  skyid_fa_face_scan_end_callbackfacematching(skyid_fa_detected_face_canvas:any){
    const face_image = this.helperSky.setFileImage(skyid_fa_detected_face_canvas);
    this.identificatioService.skyid_fa_face_scan_end_callbackfacematching(this.binaryFile, face_image, 
      this.bearToken, this.response_liveness.response_data.document_uniqueName).subscribe((data:any) => {
        this.response_face = data;
        this.loadSpinnerDisplay = false;
        skyid.skyid_fa_stop_webcam();
        this.displayButton = true;
      }, error => {
        skyid.skyid_fa_stop_webcam();
        alert("Try later")
        this.displayButton = true;
      });
  }

}
