import { Component } from '@angular/core';

interface ParentItemData {
  key: number;
  name: string;
  platform: string;
  version: string;
  upgradeNum: number | string;
  creator: string;
  createdAt: string;
  expand: boolean;
}

interface workflowInterface {
  title: string;
  selected: boolean;
}


@Component({
  selector: 'app-signataire',
  templateUrl: './signataire.component.html',
  styleUrls: ['./signataire.component.scss']
})
export class SignataireComponent {
  checked = false;
  loading = false;
  indeterminate = false;

  selected : string = "";

  isVisible = false;
  pdfSrc = "https://vadimdez.github.io/ng2-pdf-viewer/assets/pdf-test.pdf";

  listOfParentData: ParentItemData[] = [{
    key: 1,
    name: 'Screem',
    platform: 'iOS',
    version: '10.3.4.5654',
    upgradeNum: 500,
    creator: 'Jack',
    createdAt: '2014-12-24 23:12:00',
    expand: false
  },
  {
    key: 2,
    name: 'Screem',
    platform: 'iOS',
    version: '10.3.4.5654',
    upgradeNum: 500,
    creator: 'Jack',
    createdAt: '2014-12-24 23:12:00',
    expand: false
  },
  {
    key: 3,
    name: 'Screem',
    platform: 'iOS',
    version: '10.3.4.5654',
    upgradeNum: 500,
    creator: 'Jack',
    createdAt: '2014-12-24 23:12:00',
    expand: false
  }];

  vegetables: workflowInterface[] = [
    {
    title : 'Signature unique',
    selected : false
    },
    {
      title : 'Signatures en série',
      selected : false
    },
    {
      title : 'Signatures en parallèles',
      selected : true
    },
    {
    title : 'Hybride',
    selected : false
    },
    {
    title : 'Délégation de signature',
    selected : false
    },
    {
    title : 'Groupe de signataires',
    selected : false
    }
  ];

  showModal(): void {
    this.isVisible = true;
  }

  handleCancel(): void {
    console.log('Button cancel clicked!');
    this.isVisible = false;
  }

  setWorkflow( title : string){
      this.vegetables.forEach((data:workflowInterface) => {
        if(data.title != title){
          data.selected = false;
        }else{
          data.selected = true;
        }
      });
      this.selected = title;
  }

  nzExpand(data: ParentItemData){
    this.listOfParentData.forEach((child : ParentItemData) => {
      if(child.key != data.key){
        child.expand = false;
      }
    })
      data.expand = !data.expand;
  }


  ngOnInit(): void {

  }
}
