import { Component, ElementRef, HostListener, ViewChild } from '@angular/core';
import { Constant } from 'src/app/helper/constant';

@Component({
  selector: 'app-test-drawing',
  templateUrl: './test-drawing.component.html',
  styleUrls: ['./test-drawing.component.scss']
})
export class TestDrawingComponent {

  @ViewChild('canvas', { static: true }) canvasRef!: ElementRef;

  private offsetX!: number;
  private offsetY!: number;
  private isDragging = false;
  constant : Constant = new Constant()

  constructor() { }

  ngOnInit(): void {
    const canvas: HTMLCanvasElement = this.canvasRef.nativeElement;
    const ctx: CanvasRenderingContext2D = canvas.getContext('2d')!;

    // Dessine l'arrière-plan d'image
    const backgroundImage = new Image();
    backgroundImage.onload = () => {
      ctx.drawImage(backgroundImage, 0, 0, canvas.width, canvas.height);

      // Dessine le SVG dans le canvas
      const svgString = '<svg width="200" height="100">' +
                        '<rect width="200" height="100" style="fill: #f0f0f0; stroke: #333; stroke-width: 2px;"/>' +
                        '</svg>';

      const DOMURL = window.URL || window.webkitURL || window;
      const img = new Image();
      const svg = new Blob([svgString], {type: 'image/svg+xml;charset=utf-8'});
      const url = DOMURL.createObjectURL(svg);

      img.onload = () => {
        ctx.drawImage(img, 50, 50);
        DOMURL.revokeObjectURL(url);
      };

      img.src = url;
    };
    backgroundImage.src = this.constant.data; 
  }

  @HostListener('mousedown', ['$event'])
  onMouseDown(event: MouseEvent) {
    const canvas: HTMLCanvasElement = this.canvasRef.nativeElement;
    const rect = canvas.getBoundingClientRect();
    const x = event.clientX - rect.left;
    const y = event.clientY - rect.top;

    // Vérifie si le clic a été fait sur le rectangle SVG
    if (x >= 50 && x <= 250 && y >= 50 && y <= 150) {
      this.offsetX = x - 50;
      this.offsetY = y - 50;
      this.isDragging = true;
    }
  }

  @HostListener('mousemove', ['$event'])
  onMouseMove(event: MouseEvent) {
    if (this.isDragging) {
      const canvas: HTMLCanvasElement = this.canvasRef.nativeElement;
      const ctx: CanvasRenderingContext2D = canvas.getContext('2d')!;
      const rect = canvas.getBoundingClientRect();
      const x = event.clientX - rect.left;
      const y = event.clientY - rect.top;

      ctx.clearRect(0, 0, canvas.width, canvas.height); // Efface le contenu du canvas
      const backgroundImage = new Image();
      backgroundImage.src = this.constant.data; // Chemin de l'image d'arrière-plan
      backgroundImage.onload = () => {
        ctx.drawImage(backgroundImage, 0, 0, canvas.width, canvas.height);

        // Dessine le SVG à la nouvelle position
        ctx.beginPath();
        ctx.rect(x - this.offsetX, y - this.offsetY, 200, 100); // Position et dimensions du SVG
        ctx.fillStyle = "#f0f0f0";
        ctx.fill();
        ctx.strokeStyle = "#333";
        ctx.lineWidth = 2;
        ctx.stroke();
      };
    }
  }

  @HostListener('mouseup')
  onMouseUp() {
    this.isDragging = false;
  }
}
