import { Component, OnInit } from '@angular/core';

interface ParentItemData {
  key: number;
  name: string;
  platform: string;
  version: string;
  upgradeNum: number | string;
  creator: string;
  createdAt: string;
  expand: boolean;
}

interface ChildrenItemData {
  key: number;
  name: string;
  date: string;
  upgradeNum: string;
}
@Component({
  selector: 'app-signer',
  templateUrl: './signer.component.html',
  styleUrls: ['./signer.component.scss']
})
export class SignerComponent  implements OnInit{


  checked = false;
  loading = false;
  indeterminate = false;

  isVisible = false;
  pdfSrc = "https://vadimdez.github.io/ng2-pdf-viewer/assets/pdf-test.pdf";

  listOfParentData: ParentItemData[] = [];
  listOfChildrenData: ChildrenItemData[] = [];



  options1 : any = {
    color: ['#07674D','#A3D37E', '#f55742'],
    tooltip: {
      trigger: 'item'
    },
    legend: {
      orient: 'vertical',
      bottom: '35%',
      left: 'right'
    },
    series: [
      {
        name: 'Access From',
        type: 'pie',
        radius: '70%',
        avoidLabelOverlap: true,
        label: {
          show: false,
          position: 'center'
        },
        emphasis: {
          label: {
            show: true,
            fontSize: 14,
            fontWeight: 'bold'
          }
        },
        labelLine: {
          show: true
        },
        data: [
          { value: 700, name: 'Demandes terminées : 50%'},
          { value: 400, name: 'Demandes en cours : 35%'},
          { value: 200, name: 'Demandes expirées : 15%'},
        ]
      }
    ]
  };

  
  showModal(): void {
    this.isVisible = true;
  }

  handleCancel(): void {
    console.log('Button cancel clicked!');
    this.isVisible = false;
  }


  nzExpand(data: ParentItemData){
    this.listOfParentData.forEach((child : ParentItemData) => {
      if(child.key != data.key){
        child.expand = false;
      }
    })
      data.expand = !data.expand;
  }


  ngOnInit(): void {
    for (let i = 0; i < 3; ++i) {
      this.listOfParentData.push({
        key: i,
        name: 'Screem',
        platform: 'iOS',
        version: '10.3.4.5654',
        upgradeNum: 500,
        creator: 'Jack',
        createdAt: '2014-12-24 23:12:00',
        expand: false
      });
    }
    for (let i = 0; i < 3; ++i) {
      this.listOfChildrenData.push({
        key: i,
        date: '2014-12-24 23:12:00',
        name: 'This is production name',
        upgradeNum: 'Upgraded: 56'
      });
    }
  }


}
