import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { every } from 'rxjs';
import { Demande } from 'src/app/modules/demande';
import { Destinataire } from 'src/app/modules/destinataire';
import { DemandeService } from 'src/app/services/demande.service';

interface ParentItemData {
  key: number;
  tdocument: string;
  tdemane: string;
  destinataires: Destinataire[];
  statut: number | string;
  createdAt: string;
}


@Component({
  selector: 'app-globale',
  templateUrl: './globale.component.html',
  styleUrls: ['./globale.component.scss']
})
export class GlobaleComponent {
  checked = false;
  loading = false;
  indeterminate = false;
  total  = 0;
  indexPage = 1;
  page = 0;
  limit = 10;

  isVisible = false;
  pdfSrc = "https://vadimdez.github.io/ng2-pdf-viewer/assets/pdf-test.pdf";

  listOfParentData: ParentItemData[] = [];
  demandesList : any;
  date!: string;
  statut: string = "";
  demand: string = "";


  constructor(private demandeService: DemandeService, private router: Router){

  }



  options1 : any = {
    color: ['#07674D','#A3D37E', '#f55742'],
    tooltip: {
      trigger: 'item'
    },
    legend: {
      orient: 'vertical',
      bottom: '35%',
      left: 'right'
    },
    series: [
      {
        name: 'Access From',
        type: 'pie',
        radius: '70%',
        avoidLabelOverlap: true,
        label: {
          show: false,
          position: 'center'
        },
        emphasis: {
          label: {
            show: true,
            fontSize: 14,
            fontWeight: 'bold'
          }
        },
        labelLine: {
          show: true
        },
        data: [
          { value: 700, name: 'Demandes terminées : 50%'},
          { value: 400, name: 'Demandes en cours : 35%'},
          { value: 200, name: 'Demandes expirées : 15%'},
        ]
      }
    ]
  };

  selectDate(event:any){
    this.date = event;
    this.getAllDemands()
    console.log(event)
  }
  selectDemand(event:any){
    this.demand = event;
    this.getAllDemands()
    console.log(event)
  }
  selectStatut(event:any){
    this.statut = event;
    this.getAllDemands()
    console.log(event)
  }

  resetInput(){
    this.page = 0;
    this.statut = "";
    this.demand = "";
    this.getAllDemands()
  }

  getAllDemands() {
    if ((this.date == null)) {
      this.date = "2500-03-27"
    } 
    this.demandeService.getAllForUser(1, this.page, this.limit, this.statut, this.demand, this.date).subscribe((data : any) =>  {
      console.log(data);
      this.demandesList = data.response_data.data;
      this.total = data.response_data.totalElements;
    })
  }

  getDemande(){
    this.demandeService.getForUser(1).subscribe((data: any) => {
      console.log(data);
      this.demandesList = data.response_data;
      this.total = this.demandesList.length;
    })
  }

  showModal(): void {
    this.isVisible = true;
  }

  selectItem(item : any){
      console.log(item);
      localStorage.setItem('request_', JSON.stringify(item));
      this.router.navigate(['home/historique'])
  }

  handleCancel(): void {
    console.log('Button cancel clicked!');
    this.isVisible = false;
  }

  nextPage(pageIndex: number) {
    this.indexPage = pageIndex;
    this.page = parseInt(`${pageIndex}`) - 1;
    this.getAllDemands();
  }

  ngOnInit(): void {
    this.getAllDemands();
  }

} 
