import { AfterViewInit, Component } from '@angular/core';
import {CdkDragDrop, moveItemInArray} from '@angular/cdk/drag-drop';
import type { EChartsOption } from 'echarts';
import { getInstanceByDom, connect } from 'echarts';
import LinearGradient from 'zrender/lib/graphic/LinearGradient';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent implements AfterViewInit{
  movies = [
    'Episode I - The Phantom Menace',
    'Episode II - Attack of the Clones',
    'Episode III - Revenge of the Sith',
    'Episode IV - A New Hope',
    'Episode V - The Empire Strikes Back',
    'Episode VI - Return of the Jedi',
    'Episode VII - The Force Awakens',
    'Episode VIII - The Last Jedi',
    'Episode IX - The Rise of Skywalker',
  ];

  drop(event: CdkDragDrop<string[]>) {
    moveItemInArray(this.movies, event.previousIndex, event.currentIndex);
  }

  options: any = {
    color: ['#07674D'],
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'shadow',
      },
    },
    grid: {
      left: '40%',
      right: '4%',
      bottom: '3%',
      containLabel: true,
    },
    xAxis: [
      {
        type: 'category',
        data: ['01/02', '01/03', '01/04', '01/05'],
        axisTick: {
          alignWithLabel: true,
        },
      },
    ],
    
    yAxis: [
      {
        type: 'value',
      },
    ],
    series: [
      {
        name: 'Counters',
        type: 'bar',
        barWidth: '30%',
        itemStyle: {
          color: new LinearGradient(0, 0, 0, 1, [
            { offset: 0, color: '#A3D37E' },
            { offset: 0.5, color: '#07674D' },
            { offset: 1, color: '#07674D' },
          ]),
        },
        emphasis: {
          itemStyle: {
            color: new LinearGradient(0, 0, 0, 1, [
              { offset: 0, color: '#A3D37E' },
              { offset: 0.5, color: '#07674D' },
              { offset: 1, color: '#07674D' },
            ]),
          },
        },
        data: [240, 112, 200, 334],
        legend: {
       
        },
      },
    ],
  };

  options1 : any = {
    color: ['#07674D','#A3D37E'],
    tooltip: {
      trigger: 'item'
    },
    legend: {
      bottom: '1%',
      left: 'center'
    },
    series: [
      {
        name: 'Access From',
        type: 'pie',
        radius: ['40%', '70%'],
        avoidLabelOverlap: false,
        label: {
          show: false,
          position: 'center'
        },
        emphasis: {
          label: {
            show: true,
            fontSize: 14,
            fontWeight: 'bold'
          }
        },
        labelLine: {
          show: false
        },
        data: [
          { value: 700, name: 'Signé : 70%'},
          { value: 300, name: 'En attente de signature : 30%'},
        ]
      }
    ]
  };

  constructor() {}

  ngAfterViewInit() {

  }

}
