import { Component } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Demande } from 'src/app/modules/demande';
import { DemandeService } from 'src/app/services/demande.service';
import { UserService } from 'src/app/services/user.service';

@Component({
  selector: 'app-online-signature',
  templateUrl: './online-signature.component.html',
  styleUrls: ['./online-signature.component.scss']
})
export class OnlineSignatureComponent {
  token!: string;
  isCollapsed = false;
  user : any;
  demande : Demande = new Demande()

  constructor(private router: Router, private userService: UserService, private route: ActivatedRoute,
    private demandeService: DemandeService
  ){

  }
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      if (params.get('token')) {
        this.token = params.get('token')!;
        this.token = this.token.substring(1);
        console.log(this.token)
        this.getDemande();
      }
    });
  }

  selectedItem: string | null = null;

  handleItemClick(item: string) {
    this.selectedItem = item;
  }

  checkToken(){

  }

  getDemande(){
      this.demandeService.getDemandeToken(this.token).subscribe((data:any) => {
        this.demande = data.response_data;
          console.log(data)
      })
  }

  getDestinatiare(){

  }
}
