import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { UserService } from 'src/app/services/user.service';

@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.scss']
})
export class HomeComponent implements OnInit {
  isCollapsed = false;
  user : any;

  constructor(private router: Router, private userService: UserService){

  }
  ngOnInit(): void {
    this.getUser()
  }

  selectedItem: string | null = null;

  handleItemClick(item: string) {
    this.selectedItem = item;
  }


  getUser(){
      this.userService.getUser("destintati18@gmail.com").subscribe((data : any) => {
        localStorage.setItem("user", JSON.stringify(data.response_data));
        console.log(data);
      })
  }
}
