package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.NotificationDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Notification;
import bmci.esign.backendend.models.enums.ENotification;
import bmci.esign.backendend.repositories.NotificationRepository;
import bmci.esign.backendend.repositories.UserRepository;
import bmci.esign.backendend.services.NotificationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Collections;
import java.util.List;

@Service
@Slf4j
public class NotificationServiceImpl implements NotificationService {
    private final NotificationRepository notificationRepository;
    private final UserRepository userRepository;
    private final IMapClassWithDto<Notification, NotificationDto> mapClassWithDto;

    public NotificationServiceImpl(NotificationRepository notificationRepository, UserRepository userRepository, IMapClassWithDto<Notification, NotificationDto> mapClassWithDto) {
        this.notificationRepository = notificationRepository;
        this.userRepository = userRepository;
        this.mapClassWithDto = mapClassWithDto;
    }


    @Override
    @Transactional(readOnly = true)
    public List<NotificationDto> loadActiveNotificationsByUserEmail(String email) {
        log.info("PROCESSING<>{loadActiveNotificationsByUserEmail}.. REQUEST {}", email);
        try {
            if (!userRepository.existsByEmail(email)) {
                log.warn("loadActiveNotificationsByUserEmail: User Not Found with EMAIL {}", email);
                return Collections.emptyList();
            }
            List<Notification> notifications = notificationRepository.findAllByDestinataire_EmailAndStatus(email, ENotification.WAITING);
            return mapClassWithDto.convertListToListDto(notifications, NotificationDto.class);
        } catch (Exception e) {
            log.error("Exception occurred while loading active notifications for User EMAIL {}: {}", email, e.getMessage());
            return Collections.emptyList();
        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
  //  public Notification createNotification(NotificationDto dto) {
    public Notification createNotification(Notification notification) {
        log.info("PROCESSING<>{createNotification}.. REQUEST {}", notification);
        try {
         //   Notification notif = mapClassWithDto.convertToEntity(dto, Notification.class);
        //    log.info("AFTER convert To Entity {}",notif);
            Notification savedNotification = notificationRepository.save(notification);
            log.info("createNotification: Notification created with ID {}", savedNotification.getId());
            return savedNotification;
        } catch (Exception e) {
            log.error("Exception occurred while creating notification: {}", e.getMessage());
            throw e;
        }
    }

    @Override
    @Transactional
    public void changeStatusByDmId(Long id, Long demandeId, ENotification status) {
        log.info("PROCESSING<>{changeStatus}.. REQUEST_ ID {} Demande_Id {}", id, demandeId);
        try {
            Notification notification;
            if(id == null){
                notification = notificationRepository.findByDemandeId(demandeId);
            }else{
                notification = notificationRepository.findById(id).get();
            }
            notification.setStatus(status);
            notificationRepository.save(notification);
        } catch (Exception e) {
            log.error("Exception occurred while creating notification: {}", e.getMessage());
            throw e;
        }
    }
}
