package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.models.Demande;
import bmci.esign.backendend.models.Destinataire;
import bmci.esign.backendend.models.User;
import bmci.esign.backendend.models.enums.EStatut;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Slf4j
public class DemandeSpecification {

    private static final String date_pattern ="yyyy-MM-dd"; // "dd-MM-yyyy"
    public static Specification<Demande> isSentBy(User user) {
        return (root, query, criteriaBuilder) ->
                criteriaBuilder.equal(root.get("user"), user);
    }

    public static Specification<Demande> isReceivedBy(User user) {
        return (root, query, criteriaBuilder) -> {
            Join<Demande, Destinataire> join = root.join("destinataires", JoinType.INNER);
            return criteriaBuilder.equal(join.get("recipient"), user);
        };
    }

    public static Specification<Demande> hasStatus(EStatut statut) {
        return (root, query, criteriaBuilder) ->
                criteriaBuilder.equal(root.get("statut"), statut);
    }

    public static Specification<Demande> withDate(String creationDate) {
        try {
            Date date = new SimpleDateFormat(date_pattern).parse(creationDate);
            log.info("creationDate_string: {} -> parse_date {}", creationDate, date);
            return (root, query, criteriaBuilder) ->
                 criteriaBuilder.equal(
                        criteriaBuilder.function("DATE", Date.class, root.get("creationDate")),
                        date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}