package bmci.esign.backendend.services;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.request.RejectRequestDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.models.Destinataire;
import org.springframework.data.domain.Page;

import java.util.List;

public interface DestinataireService {
    DestinataireDto addDestinataire(DestinataireDto destinataireDto);
    List<DestinataireDto> addAll(List<DestinataireDto> destinataireDtos);
    DestinataireDto updateDestinataire(DestinataireDto destinataireDto, Long id);
    DestinataireDto getDestinataire(Long id);
    Destinataire findDestinataire(Long id);
    List<DestinataireDto> findAllByDemandeId(Long id);
    Page<DemandeDto> findAllDemandesToSigne(FilterDto destinataireFilterDto);
    List<DashboardChart> loadSignDmChart(String email);
    String rejectDemandByDestinataire(RejectRequestDto dto);
}
