package bmci.esign.backendend.services;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.request.GlobaleRequestDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.response.TableDto;
import bmci.esign.backendend.models.Demande;
import org.springframework.data.domain.Page;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface DemandeService {
    DemandeDto addDemande(DemandeDto demandeDto);
    DemandeDto updateDemande(DemandeDto demandeDto, Long id);
    DemandeDto getDemande(Long id);
    Demande findDemande(Long id);
    void processEmail(Demande demande);
    String relaunchUser(Long idDemand, Long idDestinatiare);
    String cancelDemand(DemandeDto demandeDto);
    void deleteDemande(Long id);
    List<DemandeDto> getAll();
    List<DemandeDto> getAllbyUser(Long userId);
    Map<String, Object> getForUserDemandeSearch(Long userId, int page, int limit, String statut, String eDemande, Date dateStart);
    Page<DemandeDto> findDemandesByUser(FilterDto filterDto);
    List<DashboardChart> loadReceivedChart(String email);
    List<DashboardChart> loadGlobalData(String email);
    Page<TableDto> loadGlobalFiltered(GlobaleRequestDto globaleRequestDto);
    int cancelExpiredDm();
}
