package bmci.esign.backendend.models.enums;

public enum ENotification {
    WAITING("En attente"),
    VIEW("Vue");

    private final String displayName;

    ENotification(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public static ENotification fromString(String text) {
        for (ENotification statut : ENotification.values()) {
            if (statut.displayName.equalsIgnoreCase(text)) {
                return statut;
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}
