package bmci.esign.backendend.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Data
@NoArgsConstructor @AllArgsConstructor
@Entity
@Table(name = "userEntity")
public class User extends AuditorEntity implements Serializable {

    @Column(length = 120)
    private String firstname;
    @Column(length = 120)
    private String lastname;
    private String avatar;
    @Column(unique = true)
    private String email;
    @Column(length = 60)
    private String password;
/*
    @OneToMany(mappedBy = "sender")
    @JsonIgnore
    private List<Demande> sentDemandes = new ArrayList<>();

    @OneToMany(mappedBy = "recipient")
    @JsonIgnore
    private List<Destinataire> receivedDemandes = new ArrayList<>();
*/
    @OneToMany(mappedBy = "user")
    @JsonIgnore
    private List<Signature> signatures = new ArrayList<>();

    @ManyToMany(fetch = FetchType.EAGER)
    @JoinTable(
        name = "user_authority",
        joinColumns = @JoinColumn(name = "user_id"),
        inverseJoinColumns = @JoinColumn(name = "authority_id")
    )
    private Set<Authority> authorities;
}
