package bmci.esign.backendend.models;

import bmci.esign.backendend.models.enums.EStatut;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor @AllArgsConstructor
@Entity
public class Destinataire {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String name;
    private String email;
    private String role;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private EStatut statut;
    private String envoie;
    private int place;

    @ManyToOne
    @JoinColumn(name = "demande_id")
    @JsonIgnore
    private Demande demande;

    @ManyToOne
    @JoinColumn(name = "user_id")
    private User recipient;

    @CreationTimestamp
    @Temporal(TemporalType.TIMESTAMP)
    private Date creationDate;

    @UpdateTimestamp
    @Temporal(TemporalType.TIMESTAMP)
    private Date modificationDate;

    @OneToMany(mappedBy = "destinataire")
    private List<Position> positions;
}
