package bmci.esign.backendend.models;

import bmci.esign.backendend.models.enums.EDemande;
import bmci.esign.backendend.models.enums.EStatut;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Data
@Entity
public class Demande extends AuditorEntity implements Serializable {

    private String confidentiality;
    private String priority;
    private String objetMail;
    private String message;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private EStatut statut;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private EDemande edemande;

    @ManyToOne
    @JoinColumn(name = "user_id")
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private User user;

    @ManyToOne
    @JoinColumn(name = "typeDocument_id")
    private TypeDocument typeDocument;

    @Temporal(TemporalType.TIMESTAMP)
    private Date expirationDate;

    @OneToMany(mappedBy = "demande", fetch = FetchType.LAZY)
    //        @JsonManagedReference
    private List<Destinataire> destinataires;
    @OneToMany(mappedBy = "demande")
    private List<Document> documents;


}
