package bmci.esign.backendend.dto;

import bmci.esign.backendend.models.User;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor @AllArgsConstructor
public class DestinataireDto {
    private Long id;
    private String name;
    private String email;
    private String role;
    private String statut;
    private String envoie;
    private int place;
    @JsonIgnore
    private DemandeDto demande;

    @JsonIgnore
    private User recipient;

    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date creationDate;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date modificationDate;
    private List<PositionDto> positions= new ArrayList<>();
}
