package bmci.esign.backendend.dto;

import bmci.esign.backendend.models.TypeDocument;
import bmci.esign.backendend.models.enums.EDemande;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor @NoArgsConstructor
public class DemandeDto implements Serializable {
    private Long id;
    private String confidentiality;
    private String priority;
    private String objetMail;
    private String message;
    private String statut;
    private String edemande;
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private UserDto user;
    private TypeDocument typeDocument;
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expirationDate;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date creationDate;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date modificationDate;
    private List<DestinataireDto> destinataires;
    private List<DocumentDto> documents;


    public String getEDemande() {
        return EDemande.valueOf(edemande).getDisplayName();
    }

    public String getStringDemand(){
        return edemande;
    }
}
