package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.request.GlobaleRequestDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.response.TableDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.services.DemandeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@RestController
@RequestMapping("/demande")
@Slf4j
public class DemandeController {
    private final DemandeService demandeService;
    public DemandeController(DemandeService demandeService) {
        this.demandeService = demandeService;
    }

    @PostMapping("/add")
        public ResponseModelStandard<Long> addDemande(@RequestBody DemandeDto demandeDto){
                log.info("NEW°DM.... {}",demandeDto.getTypeDocument());
                try {
                        demandeService.addDemande(demandeDto);
                        return new ResponseModelStandard<>("000");
                }catch (Exception e){
                        log.error("EXCEPTION_addDemande Message: {}",e.getMessage(),e);
                        return new ResponseModelStandard<>("099");
                }
        }

        @GetMapping("/get")
        public ResponseModelStandard<DemandeDto> getDemande(@RequestParam( name = "id") Long id){
                try {
                      DemandeDto demandeDto =  demandeService.getDemande(id);
                        return new ResponseModelStandard<>("000", demandeDto);
                }catch (Exception e){
                        return new ResponseModelStandard<>("099");
                }
        }

        @GetMapping("/relaunch")
        public ResponseModelStandard<Long> relaunchDemande(@RequestParam( name = "idDemand") Long id,
                                                           @RequestParam(name = "idDestinataire") Long idDestinataire){
                try {
                        String message =  demandeService.relaunchUser(id, idDestinataire);
                        if(message.equals("success")){
                                return new ResponseModelStandard<>("000");
                        }
                        return new ResponseModelStandard<>("099");
                }catch (Exception e){
                        return new ResponseModelStandard<>("099");
                }
        }

        @GetMapping("/canceled")
        public ResponseModelStandard<Long> canceledDemande(@RequestParam( name = "idDemand") Long id){
                try {
                        DemandeDto demandeDto = demandeService.getDemande(id);
                        if(demandeDto.getStatut().equals(EStatut.WAITING.name())){
                                String message =  demandeService.cancelDemand(demandeDto);
                                if(message.equals("success")){
                                        return new ResponseModelStandard<>("000");
                                }
                        }
                        return new ResponseModelStandard<>("099");
                }catch (Exception e){
                        return new ResponseModelStandard<>("099");
                }
        }

        @GetMapping("/getForUser")
        public ResponseModelStandard<List<DemandeDto>> getForUserDemande(@RequestParam(name = "id") Long id){
                try {
                        List<DemandeDto> demandeDtoList = demandeService.getAllbyUser(id);
                        return new ResponseModelStandard<>("000",demandeDtoList);
                }catch (Exception e){
                        return new ResponseModelStandard<>("099");
                }
        }

        @GetMapping("/getForUser/search")
        public ResponseModelStandard<Map<String, Object>> getForUserDemandeSearch(@RequestParam(name = "id") Long id,
                                                                                  @RequestParam(name = "page") int page,
                                                                                  @RequestParam(name = "limit") int limit,
                                                                                  @RequestParam(name = "statut") String statut,
                                                                                  @RequestParam(name = "eDemande") String eDemande,
                                                                                  @RequestParam(name = "date") @DateTimeFormat(pattern = "yyyy-MM-dd") Date dateStart){
                try {
                        Map<String, Object> demandeDtoList = demandeService.getForUserDemandeSearch(id, page, limit, statut,eDemande, dateStart);
                        return new ResponseModelStandard<>("000",demandeDtoList);
                }catch (Exception e){
                        return new ResponseModelStandard<>("099");
                }
        }

    @PostMapping("/signatures")
    public ResponseModelStandard<Page<DemandeDto>> getDemandesByUser(@RequestBody FilterDto filterDto){
        try {
            Page<DemandeDto> demandeDtoList = demandeService.findDemandesByUser(filterDto);
            return new ResponseModelStandard<>("000",demandeDtoList);
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }

    @GetMapping("/chart")
    public ResponseModelStandard<List<DashboardChart>> chartSignDemandes(@RequestParam(name = "email") String email){
         try {
                 List<DashboardChart> dashboardCharts =demandeService.loadReceivedChart(email);
                 if(dashboardCharts == null){
                         return new ResponseModelStandard<>("099","Missing data");
                 }
                 return new ResponseModelStandard<>("000", dashboardCharts);
         }catch (Exception e){
                 return new ResponseModelStandard<>("099");
         }
    }

    @PostMapping("/global")
    public ResponseModelStandard<Page<TableDto>> loadGlobalFilteredDm(@RequestBody GlobaleRequestDto dto){
         try {
             if(dto.getPage() == null || dto.getSize() == null || dto.getPage() < 0 || dto.getSize() <= 0){
                 return new ResponseModelStandard<>("099","Page or Size cannot be negative or Null");
             }
            return new ResponseModelStandard<>("000", demandeService.loadGlobalFiltered(dto));
         }catch (Exception e){
                 return new ResponseModelStandard<>("099");
         }
    }

    @PostMapping("/check")
    public ResponseModelStandard<?> loadGlobalFilteredDm(){
            return new ResponseModelStandard<>("000", demandeService.cancelExpiredDm());
    }

}
