package bmci.esign.backendend.config;

import bmci.esign.backendend.dto.StatutDto;
import bmci.esign.backendend.dto.TypeDemandeDto;
import bmci.esign.backendend.models.enums.EDemande;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.services.StatutService;
import bmci.esign.backendend.services.TypeDemandeService;
import bmci.esign.backendend.services.TypeDocumentService;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Date;


public class InitData {

    private final StatutService statutService;
    private final TypeDocumentService typeDocumentService;
    private final TypeDemandeService typeDemandeService;


    public InitData(StatutService statutService, TypeDocumentService typeDocumentService, TypeDemandeService typeDemandeService) {
        this.statutService = statutService;
        this.typeDocumentService = typeDocumentService;
        this.typeDemandeService = typeDemandeService;
    }

    @Bean
    CommandLineRunner runner(){

        return args -> {
            StatutDto statutDto = statutService.addStatut(new StatutDto(0L, EStatut.WAITING, new Date(), new Date()
            ));
            StatutDto statutDto1 = statutService.addStatut(new StatutDto(0L, EStatut.CANCELED, new Date(), new Date()
            ));
            StatutDto statutDto2 = statutService.addStatut(new StatutDto(0L, EStatut.COMPLETE, new Date(), new Date()
            ));


            TypeDemandeDto typeDemandeDto = typeDemandeService.addTypeDemande(new TypeDemandeDto(0L, "Parallèle", new Date(), new Date()));
            TypeDemandeDto typeDemandeDto1 = typeDemandeService.addTypeDemande(new TypeDemandeDto(0L, "Séquence", new Date(), new Date()));
        };
    }



}
