<!doctype html>
<html lang="fr">
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Notification d'expiration de licence</title>
    <style media="all">
      body {
        font-family: Helvetica, sans-serif;
        -webkit-font-smoothing: antialiased;
        font-size: 16px;
        line-height: 1.3;
        -ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%;
        background-color: #f4f5f6;
        margin: 0;
        padding: 0;
      }
      table {
        border-collapse: separate;
        mso-table-lspace: 0pt;
        mso-table-rspace: 0pt;
        width: 100%;
      }
      table td {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        vertical-align: top;
      }
      .container {
        margin: 0 auto !important;
        max-width: 600px;
        padding: 0;
        padding-top: 24px;
        width: 600px;
      }
      .content {
        box-sizing: border-box;
        display: block;
        margin: 0 auto;
        max-width: 600px;
        padding: 0;
      }
      .main {
        background: #ffffff;
        border: 1px solid #eaebed;
        border-radius: 16px;
        width: 100%;
      }
      .wrapper {
        box-sizing: border-box;
        padding: 24px;
      }
      .footer {
        clear: both;
        padding-top: 24px;
        text-align: center;
        width: 100%;
      }
      .footer td, .footer p, .footer span, .footer a {
        color: #9a9ea6;
        font-size: 16px;
        text-align: center;
      }
      p {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        font-weight: normal;
        margin: 0;
        margin-bottom: 16px;
      }
      a {
        color: #0867ec;
        text-decoration: underline;
      }
      .btn-primary table td {
        background: linear-gradient(45deg, #07674D, #0ECD99);
      }
      .btn-primary a {
        background: linear-gradient(45deg, #07674D, #0ECD99);
        border-color: #07674D;
        color: #ffffff;
        text-decoration: none;
        display: inline-block;
        padding: 10px 20px;
        border-radius: 5px;
      }
      @media all {
        .btn-primary table td:hover {
          background-color: #218838 !important;
        }
        .btn-primary a:hover {
          background-color: #218838 !important;
          border-color: #218838 !important;
        }
      }
      @media only screen and (max-width: 640px) {
        .main p, .main td, .main span {
          font-size: 16px !important;
        }
        .wrapper {
          padding: 8px !important;
        }
        .content {
          padding: 0 !important;
        }
        .container {
          padding: 0 !important;
          padding-top: 8px !important;
          width: 100% !important;
        }
        .btn table {
          max-width: 100% !important;
          width: 100% !important;
        }
        .btn a {
          font-size: 16px !important;
          max-width: 100% !important;
          width: 100% !important;
        }
      }
      @media all {
        .apple-link a {
          color: inherit !important;
          font-family: inherit !important;
          font-size: inherit !important;
          font-weight: inherit !important;
          line-height: inherit !important;
          text-decoration: none !important;
        }
        #MessageViewBody a {
          color: inherit;
          text-decoration: none;
          font-size: inherit;
          font-family: inherit;
          font-weight: inherit;
          line-height: inherit;
        }
      }
    </style>
  </head>
  <body>
    <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
      <tr>
        <td>&nbsp;</td>
        <td class="container">
          <div class="content">
            <table role="presentation" border="0" cellpadding="0" cellspacing="0">
              <tr>
                <td class="wrapper">
                  <p>Bonjour ${name},</p>
                  <p>${message}</p>
                  <p>Veuillez cliquer sur le lien ci-dessous pour procéder à la signature :</p>
                  <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="btn btn-primary">
                    <tbody>
                      <tr>
                        <td align="left">
                          <table role="presentation" border="0" cellpadding="0" cellspacing="0">
                            <tbody>
                              <tr>
                                <td> <a href="${url_sign}" target="_blank">Cliquez ici pour signer</a> </td>
                              </tr>
                            </tbody>
                          </table>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </td>
              </tr>
            </table>
            <div class="footer">
              <table role="presentation" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td class="content-block">
                    <span class="apple-link">BANQUE MAROCAINE POUR LE COMMERCE ET L'INDUSTRIE (BMCI)</span>
                  </td>
                </tr>
                <tr>
                  <td class="content-block powered-by">
                    Fait à <b>Casablanca</b> le &nbsp;<span>${day_date}</span>
                  </td>
                </tr>
              </table>
            </div>
          </div>
        </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </body>
</html>
