<!doctype html>
<html lang="en">
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <title>Nouvelle Demande - BMCI</title>
    <style>
      body {
        font-family: Helvetica, Arial, sans-serif;
        background-color: #f4f5f6;
        margin: 0;
        padding: 0;
        color: #333;
      }
      .container {
        max-width: 600px;
        margin: 0 auto;
        padding: 24px;
      }
      .content {
        background-color: #ffffff;
        border: 1px solid #eaebed;
        border-radius: 16px;
        padding: 24px;
      }
      .footer {
        text-align: center;
        color: #9a9ea6;
        font-size: 14px;
        margin-top: 24px;
      }
      .btn-primary {
        display: inline-block;
        padding: 12px 24px;
        background: linear-gradient(45deg, #07674D, #0ECD99);
        color: #ffffff;
        text-decoration: none;
        border-radius: 4px;
        font-weight: bold;
      }
      .btn-primary:hover {
        background: linear-gradient(45deg, #065942, #0bb689);
      }
      @media only screen and (max-width: 640px) {
        .container {
          padding: 16px;
        }
        .content {
          padding: 16px;
        }
        .btn-primary {
          width: 100%;
          text-align: center;
        }
      }
    </style>
  </head>
  <body>
    <div class="container">
      <div class="content">
        <p>Bonjour ${name},</p>
        <p>${message}</p>
        <p>Veuillez cliquer sur le lien ci-dessous pour procéder à la signature :</p>
        <p><a href="${url_sign}" target="_blank">Cliquez ici pour ${role}</a></p>
      </div>
      <div class="footer">
        <p>BANQUE MAROCAINE POUR LE COMMERCE ET L'INDUSTRIE (BMCI)</p>
        <p>Fait à <b>Casablanca</b> le <span>${day_date}</span></p>
      </div>
    </div>
  </body>
</html>
