package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.UserDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.User;
import bmci.esign.backendend.repositories.UserRepository;
import bmci.esign.backendend.services.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

@Service
@Slf4j
public class UserServiceImpl implements UserService {

    @Autowired
    private UserRepository userRepository;

    @Autowired
    private IMapClassWithDto<User, UserDto> userMapping;


    @Override
    public UserDto addUser(UserDto userDto) {
        User user = userMapping.convertToEntity(userDto, User.class);
        user = userRepository.save(user);
        return userMapping.convertToDto(user, UserDto.class);
    }

    @Override
    public UserDto updateUser(UserDto userDto, Long id) {
        Optional<User> user = userRepository.findById(id);
        if(user.isPresent()){
            if(userDto.getId().equals(user.get().getId())){
                User userConvert = userMapping.convertToEntity(userDto, User.class);
                userRepository.save(userConvert);
                return userDto;
            }
        }
        return null;
    }

    @Override
    public UserDto getUser(Long id) {
        return  userMapping.convertToDto(userRepository.findById(id).orElse(null), UserDto.class);
    }

    @Override
    public User findUser(Long id) {
        return userRepository.findById(id).orElse(null);
    }

    @Override
    public UserDto findByEmail(String email) {
        log.info("PROCESSING<>{findByEmail}... REQUEST: {}", email);
        Optional<User> user = userRepository.findByEmail(email);
        return user.map(value -> userMapping.convertToDto(value, UserDto.class)).orElse(null);
    }
}
