package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.TypeDocumentDto;
import bmci.esign.backendend.dto.request.TypeDocAddDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.TypeDocument;
import bmci.esign.backendend.repositories.TypeDocumentRepository;
import bmci.esign.backendend.services.TypeDocumentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class TypeDocumentServiceImpl implements TypeDocumentService {

    @Autowired
    private TypeDocumentRepository typeDocumentRepository;
    @Autowired
    private IMapClassWithDto<TypeDocument, TypeDocumentDto> typeDocumentMapping;

    @Override
    public TypeDocumentDto addTypeDocument(TypeDocAddDto type) {
        log.info("PROCESSING<>{addTypeDocument}.. REQUEST {}",type);
        TypeDocument typeDocument=new TypeDocument();
        typeDocument.setName(type.getType());
        typeDocument = typeDocumentRepository.save(typeDocument);
        return typeDocumentMapping.convertToDto(typeDocument, TypeDocumentDto.class);
    }

    @Override
    public List<TypeDocumentDto> getAll() {
          log.info("PROCESSING<>{TypeDocument_getAll}..");
        List<TypeDocument> typeDocuments = typeDocumentRepository.findAll();
        return typeDocumentMapping.convertListToListDto(typeDocuments, TypeDocumentDto.class);
    }
}
