package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.StatutDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Statut;
import bmci.esign.backendend.repositories.StatutRepository;
import bmci.esign.backendend.services.StatutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class StatutServiceImpl implements StatutService {
    @Autowired
    private StatutRepository statutRepository;

    @Autowired
    private IMapClassWithDto<Statut, StatutDto> statutMapping;

    @Override
    public StatutDto addStatut(StatutDto statutDto) {
        Statut statut = statutMapping.convertToEntity(statutDto, Statut.class);
        statut = statutRepository.save(statut);
        return statutMapping.convertToDto(statut, StatutDto.class);
    }

    @Override
    public StatutDto getStatut(Long id) {
        return null;
    }

    @Override
    public List<StatutDto> getAll() {
        List<Statut> statuts = statutRepository.findAll();
        return statutMapping.convertListToListDto(statuts, StatutDto.class);
    }
}
