package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.SignatureDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Signature;
import bmci.esign.backendend.repositories.SignatureRepository;
import bmci.esign.backendend.services.SignatureService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
@Slf4j
public class SignatureServiceImpl implements SignatureService {

    @Autowired
    private SignatureRepository signatureRepository;

    @Autowired
    private IMapClassWithDto<Signature, SignatureDto> signatureMapping;

    @Override
    public SignatureDto addSignature(SignatureDto signatureDto) {
        Signature signature = signatureMapping.convertToEntity(signatureDto, Signature.class);
        signature = signatureRepository.save(signature);
        return signatureMapping.convertToDto(signature, SignatureDto.class);
    }

    @Override
    public SignatureDto updateSignature(SignatureDto signatureDto, Long id) {
        return null;
    }

    @Override
    public SignatureDto getSignature(Long id) {
        return null;
    }

    @Override
    public SignatureDto findByUserId(Long id) {
        Optional<Signature> signatures = signatureRepository.findByUserId(id);
        if(signatures.isEmpty()){
            log.error("Signature Not Found for userId {}",id);
            return null;
        }
        return signatureMapping.convertToDto(signatures.get(), SignatureDto.class);
    }
}
