package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.DocumentDto;
import bmci.esign.backendend.dto.PositionDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Document;
import bmci.esign.backendend.models.Position;
import bmci.esign.backendend.repositories.PositionRepository;
import bmci.esign.backendend.services.PositionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PositionServiceImpl implements PositionService {
    @Autowired
    private PositionRepository positionRepository;

    @Autowired
    private IMapClassWithDto<Position, PositionDto> positionMapping;


    @Override
    public PositionDto addPosition(PositionDto positionDto) {
        Position position = positionMapping.convertToEntity(positionDto,Position.class);
        position = positionRepository.save(position);
        return positionMapping.convertToDto(position, PositionDto.class);
    }

    @Override
    public PositionDto updatePosition(PositionDto positionDto, Long id) {
        return null;
    }

    @Override
    public PositionDto getPosition(Long id) {
        return null;
    }

    @Override
    public List<PositionDto> findAllByDestinataireId(Long id) {
        List<Position> positions = positionRepository.findAllByDestinataireId(id);
        return positionMapping.convertListToListDto(positions, PositionDto.class);
    }
}
