package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.models.MailRequest;
import bmci.esign.backendend.models.enums.EMailStatus;
import bmci.esign.backendend.repositories.MailRequestRepository;
import bmci.esign.backendend.services.EmailService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.core.env.Environment;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@Service
@Slf4j
public class EmailServiceImpl implements EmailService {
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private Environment environment;
    @Autowired
    private MailRequestRepository mailRequestRepository;
    @Autowired
    private Configuration config ;
    @Value("${spring.mail.username}")
    private String senderMail;
    private static final String CHARACTERS = "0123456789AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";
    private static final int CODE_LENGTH = 16;
//    private static final String TEMPLATE_NAME="sendDoc.ftl";
    private static final String NEW_DM_TEMPLATE="demande.ftl";
    private static final String RELANCE_DM_TEMPLATE="relance.ftl";
    private static final String EXPIRED_DM_TEMPLATE="test.ftl";
    @Override
    public String generateVerificationCode() {
        Random random = new Random();
        StringBuilder code = new StringBuilder(CODE_LENGTH);
        for (int i = 0; i < CODE_LENGTH; i++) {
            code.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return code.toString();
    }

    @Override
    public String generateUrl(String sdkType) {
        return null;
    }

    @Override
    public void sendEmail(MailRequest req, Map<String, String> model, int emailType) {
        log.info("PROCESSING<>{sendEmail} REQUEST {}", req.toString());
        MimeMessage mimeMessage =  mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        String subject = "" ;
        String url_sign = "";

        Template template = null;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.FRANCE);
            // File footerfile = ResourceUtils.getFile("classpath:" + Utils.staticImgFolder + "file_footer.png");
            helper = new MimeMessageHelper( mimeMessage, true);
            if(req.getEmail_type().equals("bmci_t1")) {
                subject=model.get("objet") ;
                url_sign= generateVerificationCode();
                model.put("url_sign", environment.getProperty("url.esign.acess")+":"+url_sign);
                model.put("day_date", LocalDateTime.now().format(formatter));
                model.put("message", model.get("message"));
                log.info("ROLE USER IN DM {}", model.get("role"));
            }
            log.info("emailType: {}", emailType);
            template = config.getTemplate(emailType == 1 ? NEW_DM_TEMPLATE : RELANCE_DM_TEMPLATE);
            String HtmlMsg = FreeMarkerTemplateUtils.processTemplateIntoString(template,model) ;

            req.setToken(url_sign);
            helper.setFrom(senderMail);
            helper.setTo(req.getDestination());
            helper.setSubject(subject);
            helper.setText(HtmlMsg,true);
            mailSender.send(mimeMessage);
            req.setStatus(EMailStatus.SENT);
            req.setUrl_sign(model.get("url_sign"));
            mailRequestRepository.save(req);

        } catch (IOException | TemplateException | MessagingException e) {
            log.error("ERROR: {sendEmail}_ Message {} ; Cause {} ; Localized {}",e.getMessage(),e.getCause(), e.getLocalizedMessage(),e);
            e.printStackTrace();
        }

    }
}
