package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.*;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.request.RequestId;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.response.GlobalTableDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.*;
import bmci.esign.backendend.models.enums.EDemande;
import bmci.esign.backendend.models.enums.ENotification;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.repositories.*;
import bmci.esign.backendend.services.DemandeService;
import bmci.esign.backendend.services.EmailService;
import bmci.esign.backendend.services.NotificationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.*;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DemandeServiceImpl implements DemandeService {

    @Autowired
    private DemandeRepository demandeRepository;
    @Autowired
    private DestinataireRepository destinataireRepository;
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private DocumentRepository documentRepository;
    @Autowired
    private EmailService emailService;
    @Autowired
    EntityManager entityManager;
    @Autowired
    private IMapClassWithDto<Demande, DemandeDto> demandeMapping;
    @Autowired
    private IMapClassWithDto<Destinataire, DestinataireDto> destinataireMapping;
    @Autowired
    private IMapClassWithDto<Position, PositionDto> positionMapping;
    @Autowired
    private IMapClassWithDto<Document, DocumentDto> documentMapping;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private UserRepository userRepository;

    @Override
    public DemandeDto addDemande(DemandeDto demandeDto) {
        log.info("PROCESSING<>{addDemande}... REQUEST_ID: {}", demandeDto.getObjetMail());
        List<DestinataireDto> destinataireDtos = demandeDto.getDestinataires();
        log.warn("destinataireDtos {}",destinataireDtos.size());
        Demande demande = demandeMapping.convertToEntity(demandeDto, Demande.class);
        demande.setStatut(EStatut.WAITING);
        demande.setEdemande(EDemande.fromString(demandeDto.getStringDemand()));
        System.out.println(demande);
        log.info("demande {} dest_id {}",demande.getDestinataires(), demande.getDestinataires().get(0).getId());
        demande = demandeRepository.save(demande);
        demandeDto = demandeMapping.convertToDto(demande, DemandeDto.class);

        if(!demande.getDocuments().isEmpty()){
            log.warn("Docs SIZE: {}",demande.getDocuments().size());
            Optional<Document> document = demande.getDocuments().stream().findFirst();
            if(document.isPresent()){
                Demande demande1 = new Demande();
                demande1.setId(demande.getId());
                document.get().setDemande(demande1);
                log.warn("SAVE_documentRepository {}",document.get().toString());
                documentRepository.save(document.get());
            }
        }
        for (DestinataireDto destinataireDto: destinataireDtos){
//            if(!userRepository.existsByEmail(destinataireDto.getEmail())){
//                userService.addUser(new UserDto(null,destinataireDto.getName(),destinataireDto.getEmail(),null,authorityRepository.findById(1L).get()));
//            }
            Optional<User> user=userRepository.findByEmail(destinataireDto.getEmail());
            destinataireDto.setStatut(EStatut.WAITING.name());
            destinataireDto.setDemande(demandeDto);
            destinataireDto.setRecipient(user.orElse(null));
        }
        List<Destinataire> destinataires = destinataireRepository.saveAll(destinataireMapping.convertListToListEntity(destinataireDtos, Destinataire.class));
        for (DestinataireDto destinataireDto: destinataireDtos){
            for (PositionDto positionDto: destinataireDto.getPositions()){
                for (Destinataire destinataire: destinataires){
                    if(destinataire.getEmail().equals(destinataireDto.getEmail())){
                        Destinataire destinataire1 = new Destinataire();
                        destinataire1.setId(destinataire.getId());
                        positionDto.setDestinataire(destinataire1);
                        positionRepository.save(positionMapping.convertToEntity(positionDto, Position.class));
        notificationService.createNotification(new Notification(demande.getObjetMail(),destinataire,demande, ENotification.WAITING));

                    }
                }

            }
        }
        demande.setDestinataires(destinataires);
        processEmail(demande);
        return demandeDto;
    }

   /*
    @Override
    public DemandeDto addDemande(DemandeDto demandeDto) {
        log.info("PROCESSING<>{addDemande}... REQUEST_ID: {}", demandeDto.getObjetMail());
        List<DestinataireDto> destinataireDtos = demandeDto.getDestinataires();
        log.warn("destinataireDtos {}", destinataireDtos.size());

        Demande demande = demandeMapping.convertToEntity(demandeDto, Demande.class);
        demande.setStatut(EStatut.WAITING);
        demande.setEdemande(EDemande.fromString(demandeDto.getStringDemand()));

        // Sauvegarder la demande avant d'ajouter les destinataires
        demande = demandeRepository.save(demande);

        // Ajouter la demande à chaque destinataire avant de les sauvegarder
        for (DestinataireDto destinataireDto : destinataireDtos) {
            Optional<User> user = userRepository.findByEmail(destinataireDto.getEmail());
            destinataireDto.setStatut(EStatut.WAITING.name());
            destinataireDto.setDemande(demandeDto);
            destinataireDto.setRecipient(user.orElse(null));
        }

        List<Destinataire> destinataires = destinataireMapping.convertListToListEntity(destinataireDtos, Destinataire.class);
        Demande finalDemande = demande;
        destinataires.forEach(destinataire -> destinataire.setDemande(finalDemande));
        destinataires = destinataireRepository.saveAll(destinataires);

        // Ajouter les positions pour chaque destinataire
        for (DestinataireDto destinataireDto : destinataireDtos) {
            for (PositionDto positionDto : destinataireDto.getPositions()) {
                for (Destinataire destinataire : destinataires) {
                    if (destinataire.getEmail().equals(destinataireDto.getEmail())) {
                        Destinataire destinataire1 = new Destinataire();
                        destinataire1.setId(destinataire.getId());
                        positionDto.setDestinataire(destinataire1);
                        positionRepository.save(positionMapping.convertToEntity(positionDto, Position.class));
                    }
                }
            }
        }

        demande.setDestinataires(destinataires);

        if(!demande.getDocuments().isEmpty()){
            log.warn("Docs SIZE: {}",demande.getDocuments().size());
            Optional<Document> document = demande.getDocuments().stream().findFirst();
            if(document.isPresent()){
                Demande demande1 = new Demande();
                demande1.setId(demande.getId());
                document.get().setDemande(demande1);
                log.warn("SAVE_documentRepository {}",document.get().toString());
                documentRepository.save(document.get());
            }
        }

        processEmail(demande);
        return demandeMapping.convertToDto(demande, DemandeDto.class);
    }
*/
    @Override
    public DemandeDto updateDemande(DemandeDto demandeDto, Long id) {
        Optional<Demande> demande = demandeRepository.findById(id);
        if(demande.isPresent()){
            if(demandeDto.getId().equals(demande.get().getId())){
                Demande demande1 = demandeMapping.convertToEntity(demandeDto, Demande.class);
                demande1.setEdemande(EDemande.fromString(demandeDto.getStringDemand()));
                demande1.setStatut(EStatut.valueOf(demandeDto.getStatut()));
                demandeRepository.save(demande1);
                return demandeDto;
            }
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public DemandeDto getDemande(Long id) {
        log.info("PROCESSING<>{getDemande}... REQUEST_DM_ID: {}", id);
        try {
            Optional<Demande> demande = demandeRepository.findById(id);
            return demande.map(value -> demandeMapping.convertToDto(value, DemandeDto.class)).orElse(null);
        } catch (Exception e) {
            log.error("Exception<getDemande> message: {} cause {}", e.getMessage(), e.getCause(), e);
            return null;
        }
    }


    @Override
    public Demande findDemande(Long id) {
        Optional<Demande> demande = demandeRepository.findById(id);
        return demande.orElse(null);
    }

    @Override
    public void processEmail(Demande demande) {
        log.info("PROCESSING<>{processEmail}...");
        List<Destinataire> destinataires = demande.getDestinataires().stream().filter(destinataire ->
                destinataire.getStatut().name().equals(EStatut.WAITING.name())).collect(Collectors.toList());

        if(demande.getEdemande().equals(EDemande.SEQUENCE) || demande.getEdemande().equals(EDemande.SIMULTANEE)){
            detectProcessActive(demande, destinataires);
            List<Destinataire> destinataireList = demande.getDestinataires().stream().filter(destinataire ->
                    destinataire.getStatut().name().equals(EStatut.COMPLETE.name())).collect(Collectors.toList());
            if(destinataireList.size() == demande.getDestinataires().size()){
                demande.setStatut(EStatut.COMPLETE);
                Optional<Demande> demande1 = demandeRepository.findById(demande.getId());
                if(demande1.isPresent()){
                    demande.setEdemande(demande1.get().getEdemande());
                    demandeRepository.save(demande);
                  //  notificationService.changeStatusByDmId(null, demande.getId(), ENotification.VIEW);
                }
            }
        }else if(demande.getEdemande().equals(EDemande.PARALLELE)){
            List<Destinataire> destinataireList = demande.getDestinataires().stream().filter(destinataire ->
                    destinataire.getStatut().name().equals(EStatut.COMPLETE.name())).collect(Collectors.toList());
            if(!destinataireList.isEmpty()){
                demande.setStatut(EStatut.COMPLETE);
                Optional<Demande> demande1 = demandeRepository.findById(demande.getId());
                if(demande1.isPresent()){
                    demande.setEdemande(demande1.get().getEdemande());
                    demandeRepository.save(demande);
                  //   notificationService.changeStatusByDmId(null, demande.getId(), ENotification.VIEW);
                }

            }else{
                detectProcessActive(demande, destinataires);
            }
        }else{

        }

    }

    private void detectProcessActive(Demande demande, List<Destinataire> destinataires) {
        if(destinataires.size() > 1){
            Destinataire destinataire = destinataires.stream().findFirst().get();
            for (Destinataire dest : destinataires){
                if(dest.getStatut().name().equals(EStatut.WAITING.name()) && dest.getPlace() == destinataire.getPlace()){
                    sendEmailRequest(demande, dest, "bmci_t1",1);
                }
            }
        }else{
            for (Destinataire dest : destinataires){
                if(dest.getStatut().name().equals(EStatut.WAITING.name())){
                    sendEmailRequest(demande, dest, "bmci_t1",1);
                }
            }
        }
    }

    @Override
    public String relaunchUser(Long idDemand, Long idDestinatiare) {
        log.info("PROCESSING<relaunchUser> REQUEST demande_ID {} User_Id {}",idDemand, idDestinatiare);
        try {
            Demande demande = findDemande(idDemand);
            Destinataire destinataire = demande.getDestinataires().stream().filter(destinataire1 -> destinataire1.getId().equals(idDestinatiare)).collect(Collectors.toList()).get(0);
            sendEmailRequest(demande, destinataire, "bmci_t1",1);
            return "success";
        }catch (Exception e){
            return "failed";
        }

    }

    @Override
    @Transactional
    public String cancelDemandById(RequestId idDemand) {
        log.info("PROCESSING<cancelDemand> REQUEST demande_Id {}", idDemand.getDemandId());
        try {
            if(idDemand.getDemandId() == null){
                log.warn("<cancelDemandById> Demande ID Null");
                return "failed";
            }
            DemandeDto demandeDto = getDemande(idDemand.getDemandId());
            if(!demandeDto.getStatut().equals(EStatut.WAITING.name())){
                log.warn("<cancelDemandById> No Statut(WAITING) found!");
                return "failed";
            }
            demandeDto.setStatut(EStatut.DELETED.name());
            EDemande eDemande = EDemande.valueOf(demandeDto.getStringDemand());
            demandeDto.setEdemande(eDemande.getDisplayName());
            updateDemande(demandeDto, demandeDto.getId());
            List<Destinataire> destinataires = destinataireRepository.findAllByDemandeId(demandeDto.getId());

            for(Destinataire destinataire : destinataires){
                if(destinataire.getStatut().equals(EStatut.WAITING)){
                    destinataire.setStatut(EStatut.DELETED);
                    destinataireRepository.save(destinataire);
                }
            }
            return "success";
        }catch (Exception e){
            return "failed";
        }
    }

    private void sendEmailRequest(Demande demande, Destinataire dest, String type, int subject) {
        MailRequest mailRequest = new MailRequest();
        Map<String,String> model = new HashMap<>();
        mailRequest.setDemandeId(demande.getId());
        mailRequest.setDestination(dest.getEmail());
        mailRequest.setName(dest.getName());
        mailRequest.setEmail_type(type);
        mailRequest.setExpirationDate(demande.getExpirationDate());
        model.put("objet", demande.getObjetMail());
        model.put("message", demande.getMessage());
        model.put("name", dest.getName());
        model.put("role", getRoleFromUser(dest.getRole()));
        emailService.sendEmail(mailRequest,model,subject);
        String message="Vous avez une nouvelle demande en attente.\n Envoyé par : "+demande.getUser().getFirstname() +" "+ demande.getUser().getLastname();
//        String message = String.format("Cher %s, vous avez une nouvelle demande avec le sujet '%s'. Veuillez la consulter dès que possible.",
//                                   demande.getUser().getLastname(),
//                                   demande.getObjetMail());
    }

    private String getRoleFromUser(String role){
        switch (role){
            case "Signataire":
                return "signer";
            case "Validateur":
                return "valider";
            case "Observateur":
                return "observer";
        }
        return "";
    }

    @Override
    public void deleteDemande(Long id) {

    }

    @Override
    public List<DemandeDto> getAll() {
        return null;
    }

    @Override
    public List<DemandeDto> getAllbyUser(Long userId) {
        List<Demande> demandes = demandeRepository.findAllByUserId(userId);
        return demandeMapping.convertListToListDto(demandes, DemandeDto.class);
    }

    @Override
    public Map<String, Object> getForUserDemandeSearch(Long userId, int page, int limit, String statut, String eDemande, Date dateStart) {
        log.info("PROCESSING<>{getForUserDemandeSearch}... REQUEST: userId {}; page {}; limit {}; ", userId, page, limit);
        Map<String, Object> resp = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateStart);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        Date date_Start = cal.getTime();

        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Demande> criteriaQuery = criteriaBuilder.createQuery(Demande.class);

        Root<Demande> root = criteriaQuery.from(Demande.class);
        Predicate namePredicate = criteriaBuilder.and(
                criteriaBuilder.equal(criteriaBuilder.coalesce(criteriaBuilder.toLong(root.get("user").get("id")), 0L), userId),
                criteriaBuilder.lessThanOrEqualTo(root.get("creationDate"), date_Start));

        if(!statut.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(statut)));
        }else if(!eDemande.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("edemande"), EDemande.fromString(eDemande)));
        }

        if(!statut.equals("") && !eDemande.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(statut)) , criteriaBuilder.equal(root.get("edemande"), EDemande.fromString(eDemande)));
        }

        namePredicate = criteriaBuilder.and(namePredicate, criteriaBuilder.lessThanOrEqualTo(root.get("creationDate"), date_Start));
        criteriaQuery.where(namePredicate);
        criteriaQuery.orderBy(criteriaBuilder.desc(root.get("creationDate")));
        int firstResult = (page) * limit;
        TypedQuery<Demande> query = entityManager.createQuery(criteriaQuery).setMaxResults(limit).setFirstResult(firstResult);

        long total = 0;
        TypedQuery<Demande> countquery = entityManager.createQuery(criteriaQuery);
        total = countquery.getResultList().size();
        //  System.out.println("total : " + total);

        resp.put("data", demandeMapping.convertListToListDto(query.getResultList(), DemandeDto.class));
        resp.put("totalElements", total);

        return resp;

    }

// Received
    @Override
    @Transactional(readOnly = true)
    public Page<DemandeDto> findDemandesByUser(FilterDto filterDto){
        log.info("PROCESSING<>{findDemandesByUser}... REQUEST: {}", filterDto);
        try {
            int page = filterDto.getPage();
            int size = filterDto.getSize();
            Pageable pageable = PageRequest.of(page, size);
            Specification<Demande> specification = buildSpecification(filterDto);
            Page<Demande> demandePage= demandeRepository.findAll(specification, pageable);
            demandePage.stream().forEach(demande -> {
                demande.setDestinataires(mapDestinatairesToDto(demande.getDestinataires()));
            });
            return demandeMapping.convertResponseToPageDto(demandePage, DemandeDto.class);
        } catch (Exception e) {
            log.error("EXCEPTION<>findAllDemandesToSigne: {}", e.getMessage(), e);
            return Page.empty();
        }
    }

    private Specification<Demande> buildSpecification(FilterDto dto) {
        return (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (dto.getCreatedDate() != null) {
                Expression<LocalDate> creationDateExpression = criteriaBuilder.function(
                        "date", LocalDate.class, root.get("creationDate"));
                predicates.add(criteriaBuilder.equal(creationDateExpression, dto.getCreatedDate()));
            }
            if (dto.getDemandeType() != null) {
                log.info("edemande: {}",dto.getDemandeType());
                predicates.add(criteriaBuilder.equal(root.get("edemande"), EDemande.fromString(dto.getDemandeType())));
            }
            if(dto.getStatut() != null ){
                log.info("statut: {}",dto.getStatut());
                predicates.add(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(dto.getStatut())));
            }
            predicates.add(criteriaBuilder.equal(root.get("user").get("email"), dto.getEmail()));
          query.orderBy(criteriaBuilder.desc(root.get("creationDate")));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
    private List<Destinataire> mapDestinatairesToDto(List<Destinataire> destinataires) {
        return destinataires.stream()
                .map(dest -> new Destinataire(
                        dest.getId(),
                        dest.getName(),
                        dest.getEmail(),
                        dest.getRole(),
                        dest.getStatut(),
                        dest.getEnvoie(),
                        dest.getPlace(),
                        dest.getTelephone(),
                        dest.getDemande(),
                        dest.getRecipient(),
                        dest.getCreationDate(),
                        dest.getModificationDate(),
                        Collections.emptyList()
                ))
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly = true)
    public List<DashboardChart> loadReceivedChart(String email) {
        log.info("PROCESSING<>{Load_received_Request}... EMAIL: {}", email);
        try {
            if(email.isEmpty()){
                return null;
            }
            return demandeMapping.mappingData(demandeRepository.loadSignaturesChart(email));
        }catch (Exception e){
            log.error("EXCEPTION<>loadSignaturesChart: {}", e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    @Transactional(readOnly = true)
    public List<DashboardChart> loadGlobalData(String email) {
        log.info("PROCESSING<>{loadGlobalData}... EMAIL: {}", email);
        try {
            if(email.isEmpty()){
                return null;
            }
            return demandeRepository.loadSignaturesChart(email);
        }catch (Exception e){
            log.error("EXCEPTION<>loadSignaturesChart: {}", e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Page<GlobalTableDto> loadGlobalFiltered(FilterDto globaleRequestDto) {
        log.info("PROCESSING<>{loadGlobalData}... EMAIL: {}", globaleRequestDto.getEmail());
        try {
            Optional<User> user = userRepository.findByEmail(globaleRequestDto.getEmail());
            if (user.isEmpty()) {
                log.error("User Not Found with Email: {}", globaleRequestDto.getEmail());
                return Page.empty();
            }
            Pageable pageable = PageRequest.of(globaleRequestDto.getPage(), globaleRequestDto.getSize());
            Specification<Demande> demandeSpecification = specification(globaleRequestDto, user.get());
            return convertResponseToPageDto(demandeRepository.findAll(demandeSpecification, pageable), user.get());
        } catch (ResourceNotFoundException ex) {
            log.error("ERROR<loadGlobalFiltered>: ResourceNotFoundException: ", ex);
        } catch (Exception ex) {
            log.error("Exception<loadGlobalFiltered>: Exception in loadGlobalFiltered: ", ex);
        }
        return Page.empty();
    }

    public static Specification<Demande> specification(FilterDto globaleRequestDto, User user) {
        return (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();

            if (globaleRequestDto.getCreatedDate() != null) {
                log.info("Global__CreationDate: {}", globaleRequestDto.getCreatedDate());
                Expression<LocalDate> creationDateExpression = criteriaBuilder.function(
                        "date", LocalDate.class, root.get("creationDate"));
                predicates.add(criteriaBuilder.equal(creationDateExpression, globaleRequestDto.getCreatedDate()));
            }

            if (globaleRequestDto.getStatut() != null) {
                log.info("Global__Statut: {}", globaleRequestDto.getStatut());
                predicates.add(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(globaleRequestDto.getStatut())));
            }

            if (globaleRequestDto.getDemandeType() == null) {
                predicates.add(criteriaBuilder.or(isSentBy(user).toPredicate(root, query, criteriaBuilder),
                        isReceivedBy(user).toPredicate(root, query, criteriaBuilder)));
            } else if ("Demande des signatures".equals(globaleRequestDto.getDemandeType())) {
                log.info("Global__Type: signatures-> {}", globaleRequestDto.getDemandeType());
                predicates.add(isSentBy(user).toPredicate(root, query, criteriaBuilder));
            } else {
                log.info("Global__Type: signer-> {}", globaleRequestDto.getDemandeType());
                predicates.add(isReceivedBy(user).toPredicate(root, query, criteriaBuilder));
            }
            query.distinct(true);
            query.orderBy(criteriaBuilder.desc(root.get("creationDate")));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }

    public static Specification<Demande> isSentBy(User user) {
        return (root, query, criteriaBuilder) -> criteriaBuilder.equal(root.get("user"), user);
    }

    public static Specification<Demande> isReceivedBy(User user) {
        return (root, query, criteriaBuilder) -> {
            Join<Demande, Destinataire> join = root.join("destinataires", JoinType.INNER);
            return criteriaBuilder.equal(join.get("recipient"), user);
        };
    }

    public Page<GlobalTableDto> convertResponseToPageDto(Page<Demande> demandes, User currentUser) {
        return demandes.map(demande -> convertToDto(demande, currentUser));
    }

    private GlobalTableDto convertToDto(Demande demande, User currentUser) {
        GlobalTableDto dto = new GlobalTableDto();
        dto.setId(demande.getId());
        dto.setConfidentiality(demande.getConfidentiality());
        dto.setPriority(demande.getPriority());
        dto.setObjetMail(demande.getObjetMail());
        dto.setMessage(demande.getMessage());
        dto.setCreationDate(demande.getCreationDate());
        dto.setTypeDocument(demande.getTypeDocument());
        dto.setDestinataires(destinataireMapping.convertListToListDto(demande.getDestinataires(), DestinataireDto.class));
        dto.setStatut(demande.getStatut());
        dto.setExpirationDate(demande.getExpirationDate());
        dto.setDocuments(documentMapping.convertListToListDto(demande.getDocuments(), DocumentDto.class));
        dto.setCurrentUser(currentUser);

        boolean isSender = demande.getUser().equals(currentUser);
        boolean isRecipient = demande.getDestinataires().stream().filter(destinataire -> destinataire.getRecipient() != null)
                .anyMatch(dest -> dest.getRecipient().equals(currentUser));

        dto.setDemandeTypeBasedOnUser(isSender, isRecipient);

        return dto;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public int cancelExpiredDm() {
        log.info("PROCESSING<cancelExpiredDm>.... Scheduled task initiated Now {}", new Date());
        try{
            List<Demande> demandes=demandeRepository.findAllByExpirationDateBeforeAndStatut(new Date(), EStatut.WAITING);
            demandes.forEach(demande -> {
                log.warn("RESULT : ID {} ExpirationDate {}", demande.getId(), demande.getExpirationDate());
                demandeRepository.updateExpiredById(demande.getId(), EStatut.CANCELED);
            //    sendEmailRequest(demande,demande.getDestinataires().get(0) , "bmci_t1", 3);
            });
            return demandes.size();
        }catch (Exception e){
            log.error("Exception<cancelExpiredDm> message: {} class {}",e.getMessage(),e.getClass(),e);
            return 0;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int findExpiringTomorrow() {
        log.info("PROCESSING<findExpiringTomorrow>.....");
        try{
            List<Demande> demandes= demandeRepository.findExpiringTomorrow();
            demandes.forEach(dm -> {
                log.info("Demande with ID {} will expire tomorrow ",dm.getId());
                sendEmailRequest(dm,dm.getDestinataires().get(0) , "bmci_t1", 2);
            });
            log.warn("demandes.size() : {}",demandes.size());
            return demandes.size();
        }catch (Exception e){
            log.error("Exception<findExpiringTomorrow> message: {} class {}",e.getMessage(),e.getClass(),e);
            return 0;
        }
    }
}