package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.AuthorityDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Authority;
import bmci.esign.backendend.repositories.AuthorityRepository;
import bmci.esign.backendend.services.AuthorityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AuthorityServiceImpl implements AuthorityService {


    @Autowired
    private AuthorityRepository authorityRepository;

    @Autowired
    private IMapClassWithDto<Authority, AuthorityDto> authorityMapping;

    @Override
    public Authority addAuthority(Authority authority) {
        if(authority == null){
            return null;
        }
        return authorityRepository.save(authority);
    }

    @Override
    public AuthorityDto getAuthority(Long id) {
        return null;
    }

    @Override
    public List<AuthorityDto> getAll() {
        List<Authority> authorities = authorityRepository.findAll();
        return authorityMapping.convertListToListDto(authorities, AuthorityDto.class);
    }
}
