package bmci.esign.backendend.repositories;

import bmci.esign.backendend.models.Notification;
import bmci.esign.backendend.models.enums.ENotification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface NotificationRepository extends JpaRepository<Notification, Long> {
    List<Notification> findAllByDestinataire_EmailAndStatus(String email, ENotification status);
    @Query("SELECT n from Notification n WHERE  n.demande.id= :id AND n.destinataire.email= :email")
    Notification findByDemandeId(@Param("id") Long id,@Param("email") String email);
}
