package bmci.esign.backendend.repositories;

import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.models.Demande;
import bmci.esign.backendend.models.enums.EStatut;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import java.util.Date;
import java.util.List;

@Repository
public interface DemandeRepository extends JpaRepository<Demande, Long>, JpaSpecificationExecutor<Demande> {
    List<Demande> findAllByUserId(Long id);
 //   @Query(value = "SELECT count(d.id) as count, d.statut as statut FROM Demande d WHERE d.user.email= :email GROUP BY d.statut")
    @Query(value = "SELECT count(d.id) as count, d.statut as statut FROM demande d inner join user_entity u " +
            "on (d.user_id= u.id) WHERE u.email= :email GROUP BY d.statut", nativeQuery = true)
    List<DashboardChart> loadSignaturesChart(@Param("email") String email);
    List<Demande> findAllByExpirationDateBeforeAndStatut(Date date, EStatut eStatut);
    @Modifying
    @Query("UPDATE Demande d set d.statut = :newStatut WHERE d.id = :id")
    int updateExpiredById(@Param("id") Long id, @Param("newStatut") EStatut newStatut);

    @Query(value = "SELECT * FROM demande d WHERE d.expiration_date <= NOW() + INTERVAL '1 days' " +
            "AND expiration_date > NOW() AND statut = 'WAITING'", nativeQuery = true)
    List<Demande> findExpiringTomorrow();
}
/*
SELECT statut as statut, SUM(count) as total
FROM (
    SELECT count(d.id) as count, d.statut as statut
    FROM demande d
    INNER JOIN user_entity u ON u.id = d.user_id
    WHERE u.email = 'anasjegoual.04@gmail.com'
    GROUP BY d.statut
    UNION ALL
    SELECT count(dem.id) as count, dem.statut as statut
    FROM demande dem
    INNER JOIN destinataire dest ON dem.id = dest.demande_id
    WHERE dest.email = 'anasjegoual.04@gmail.com'
    GROUP BY dem.statut
) GROUP BY statut;
 */